/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class TestInternalFrames
extends JFrame {
    private Desktop theDesktop;
    private Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public TestInternalFrames() {
        super("VTK Internal Frame Demo");
        this.setSize(900, 900);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        this.addWindowListener(windowAdapter);
        this.getContentPane().add(new SplitFrame());
        new MenuMgr();
        this.setVisible(true);
    }

    public void addMenuBar(JMenuBar jMenuBar) {
        this.setJMenuBar(jMenuBar);
    }

    public static void main(String[] stringArray) {
        TestInternalFrames testInternalFrames = new TestInternalFrames();
    }

    private class KillAction
    extends AbstractAction {
        public KillAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    private class CreateWindowAction
    extends AbstractAction {
        private int layer = 0;

        public CreateWindowAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TestInternalFrames.this.theDesktop.add((Component)new VTKFrame(340, 200), new Integer(this.layer));
        }
    }

    private class MenuMgr
    extends JMenuBar {
        JMenu menu;

        public MenuMgr() {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.menu = new JMenu("File");
            this.menu.add(new CreateWindowAction("Create New VTK Window"));
            this.menu.add(new KillAction("Exit"));
            this.add(this.menu);
            TestInternalFrames.this.addMenuBar(this);
        }
    }

    private class VTKFrame
    extends JInternalFrame {
        public VTKFrame(int n, int n2) {
            super("VTK Window", true, true, true, true);
            Dimension dimension = new Dimension();
            dimension.height = 300;
            dimension.width = 300;
            this.setSize(dimension);
            this.getContentPane().setLayout(new BorderLayout());
            this.setLocation(n, n2);
            this.getContentPane().add((Component)new TestVTKCanvas(), "Center");
            this.pack();
            this.setVisible(true);
        }
    }

    private class Tabbed
    extends JTabbedPane {
        public Tabbed() {
            this.addTab("vtk1", new TestVTKCanvas());
            this.addTab("vtk2", new TestVTKCanvas());
            this.setMinimumSize(new Dimension(300, 300));
            this.setSelectedIndex(1);
        }
    }

    private class Desktop
    extends JDesktopPane {
        public Desktop() {
            this.setPreferredSize(TestInternalFrames.this.screenSize);
            this.setDragMode(JDesktopPane.OUTLINE_DRAG_MODE);
            this.add(new VTKFrame(10, 10));
            this.add(new VTKFrame(500, 10));
        }
    }

    private class SplitFrame
    extends JSplitPane {
        public SplitFrame() {
            super(0);
            this.setDividerLocation(((TestInternalFrames)TestInternalFrames.this).screenSize.height / 2);
            this.setContinuousLayout(true);
            this.setOneTouchExpandable(true);
            this.add(TestInternalFrames.this.theDesktop = new Desktop());
            this.add(new Tabbed());
        }
    }
}

