/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.movie;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.movie.FileToolBox;
import com.artenum.cassandra.plugin.movie.MovieControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Observable;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import vtk.vtkActor;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class MoviePlugin
extends Observable
implements CassandraPlugin,
RemoveListener {
    private String name = "Movie plugin";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private MovieControlUI controlUI;
    private vtkDataSetReader dataSetVTK;
    private vtkDataSetMapper mapperVTK;
    private vtkActor actorVTK;
    private vtkLookupTable lookupTableVTK;
    private vtkScalarBarActor scalarBarVTK;
    private Filter filerImpl;
    private VtkObject actor;
    private VtkObject mapper;
    private VtkObject dataset;
    private VtkObject filter;
    private File[] fileList;

    public MoviePlugin(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame frame) {
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.filerImpl = new FilterImpl();
        this.filerImpl.addRemoveListener((RemoveListener)this);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".vtk");
            }

            public String getDescription() {
                return "Vtk files";
            }
        });
        if (jFileChooser.showOpenDialog(frame) != 0) {
            return;
        }
        this.fileList = jFileChooser.getSelectedFiles();
        FileToolBox.sortFileList(this.fileList);
        this.dataSetVTK = new vtkDataSetReader();
        this.dataSetVTK.SetFileName(this.fileList[0].getAbsolutePath());
        this.dataSetVTK.Update();
        this.mapperVTK = new vtkDataSetMapper();
        this.mapperVTK.SetInput(this.dataSetVTK.GetOutput());
        this.mapperVTK.Update();
        this.actorVTK = new vtkActor();
        this.actorVTK.SetMapper((vtkMapper)this.mapperVTK);
        pipeLineManager.addDataSet((Object)this.dataSetVTK.GetOutput(), "Dynamic");
        pipeLineManager.addMapper((Object)this.mapperVTK, "");
        pipeLineManager.setActorVisible(pipeLineManager.addActor((Object)this.actorVTK, "Dynamic"), true);
        if (this.dataSetVTK.GetOutput().GetScalarRange() != null) {
            this.lookupTableVTK = new vtkLookupTable();
            this.lookupTableVTK.SetHueRange(0.66667, 0.0);
            this.lookupTableVTK.SetTableRange(this.dataSetVTK.GetOutput().GetScalarRange());
            this.lookupTableVTK.Build();
            this.mapperVTK.SetLookupTable((vtkScalarsToColors)this.lookupTableVTK);
            this.mapperVTK.SetScalarRange(this.dataSetVTK.GetOutput().GetScalarRange());
            this.scalarBarVTK = new vtkScalarBarActor();
            this.scalarBarVTK.SetLookupTable((vtkScalarsToColors)this.lookupTableVTK);
            pipeLineManager.addLookupTable(this.lookupTableVTK, "Dynamic");
            pipeLineManager.setActorVisible(pipeLineManager.addScalarBar(this.scalarBarVTK, "Dynamic"), true);
        }
        this.filter = pipeLineManager.addFilter(this.filerImpl, "Dynamic file loader");
        this.filerImpl.getOutputDataSet().add(this.dataSetVTK.GetOutput());
        pipeLineManager.notifyConnectivityChange(this.filter);
        this.controlUI = new MovieControlUI(pipeLineManager, this, frame);
        this.contextualMenu = new JPopupMenu("Movie menu");
        JMenuItem jMenuItem = new JMenuItem("Show control");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoviePlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(jMenuItem);
        this.contextualMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MoviePlugin.this.remove();
            }
        });
        this.contextualMenu.add(jMenuItem2);
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
    }

    public File[] getVtkFileList() {
        return this.fileList;
    }

    public void updateInputFile(File file) {
        if (!file.exists()) {
            return;
        }
        this.dataSetVTK.SetFileName(file.getAbsolutePath());
        this.dataSetVTK.Update();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MoviePlugin.this.pipelineManager.validateView();
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public String toString() {
        return this.getName();
    }
}

