/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ResourceBundle;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.data.XYDataset;

public class PeriodMarkerPlot
extends XYPlot
implements ValueAxisPlot {
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public PeriodMarkerPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2) {
        super(xYDataset, valueAxis, valueAxis2, null);
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public String getPlotType() {
        return localizationResources.getString("Period_Marker_Plot");
    }

    public XYDataset getTempXYDataset() {
        return this.getDataset();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Insets insets = this.getInsets();
        if (insets != null) {
            rectangle2D = new Rectangle2D.Double(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = new AxisSpace();
        ValueAxis valueAxis = this.getDomainAxis();
        ValueAxis valueAxis2 = this.getRangeAxis();
        axisSpace = valueAxis.reserveSpace(graphics2D, this, rectangle2D, this.getDomainAxisEdge(), axisSpace);
        axisSpace = valueAxis2.reserveSpace(graphics2D, this, rectangle2D, this.getRangeAxisEdge(), axisSpace);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.drawBackground(graphics2D, rectangle2D2);
        double d = 0.0;
        this.getDomainAxis().draw(graphics2D, d, rectangle2D, rectangle2D2, this.getDomainAxisEdge());
        this.getRangeAxis().draw(graphics2D, d, rectangle2D, rectangle2D2, this.getRangeAxisEdge());
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D2);
        XYDataset xYDataset = this.getTempXYDataset();
        if (xYDataset != null) {
            int n = xYDataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                this.drawMarkedPeriods(xYDataset, i, graphics2D, rectangle2D2);
            }
        }
        this.drawOutline(graphics2D, rectangle2D2);
        graphics2D.setClip(shape);
    }

    private void drawMarkedPeriods(XYDataset xYDataset, int n, Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Object object;
        int n2;
        Color color = Color.gray;
        graphics2D.setPaint(color);
        graphics2D.setStroke(AbstractRenderer.DEFAULT_STROKE);
        float f = 0.1f;
        if (color instanceof Color && (n2 = ((Color)(object = color)).getRed() + ((Color)object).getGreen() + ((Color)object).getBlue()) > 255) {
            f = f * (float)n2 / 255.0f;
        }
        object = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        double d = rectangle2D.getMinY();
        double d2 = rectangle2D.getMaxY();
        int n3 = xYDataset.getItemCount(n);
        for (int i = 0; i < n3; ++i) {
            int n4;
            if (xYDataset.getYValue(n, i).doubleValue() == 0.0) continue;
            Number number = i > 0 ? (Number)new Long((xYDataset.getXValue(n, i).longValue() + xYDataset.getXValue(n, i - 1).longValue()) / 2L) : (Number)xYDataset.getXValue(n, i);
            for (n4 = i + 1; n4 < n3 && xYDataset.getYValue(n, n4).doubleValue() != 0.0; ++n4) {
            }
            i = n4;
            Number number2 = n4 < n3 ? (Number)new Long((xYDataset.getXValue(n, n4 - 1).longValue() + xYDataset.getXValue(n, n4).longValue()) / 2L) : (Number)xYDataset.getXValue(n, n4 - 1);
            double d3 = this.getDomainAxis().translateValueToJava2D(number.doubleValue(), rectangle2D, this.getDomainAxisEdge());
            double d4 = this.getDomainAxis().translateValueToJava2D(number2.doubleValue(), rectangle2D, this.getDomainAxisEdge());
            this.markPeriod(d3, d4, d, d2, graphics2D);
        }
        graphics2D.setComposite((Composite)object);
    }

    private void markPeriod(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        graphics2D.fill(new Rectangle2D.Double(d, d3, d2 - d, d4 - d3));
    }

    public void zoom(double d) {
    }
}

