/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.Arrays;
import java.util.Date;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.HighLowDataset;
import org.jfree.data.OHLCDataItem;

public class OHLCDataset
extends AbstractSeriesDataset
implements HighLowDataset {
    private String name;
    private OHLCDataItem[] data;

    public OHLCDataset(String string, OHLCDataItem[] oHLCDataItemArray) {
        this.name = string;
        this.data = oHLCDataItemArray;
    }

    public String getSeriesName(int n) {
        return this.name;
    }

    public Number getXValue(int n, int n2) {
        return new Long(this.data[n2].getDate().getTime());
    }

    public Date getXDate(int n, int n2) {
        return this.data[n2].getDate();
    }

    public Number getYValue(int n, int n2) {
        return this.getCloseValue(n, n2);
    }

    public Number getHighValue(int n, int n2) {
        return this.data[n2].getHigh();
    }

    public Number getLowValue(int n, int n2) {
        return this.data[n2].getLow();
    }

    public Number getOpenValue(int n, int n2) {
        return this.data[n2].getOpen();
    }

    public Number getCloseValue(int n, int n2) {
        return this.data[n2].getClose();
    }

    public Number getVolumeValue(int n, int n2) {
        return this.data[n2].getVolume();
    }

    public int getSeriesCount() {
        return 1;
    }

    public int getItemCount(int n) {
        return this.data.length;
    }

    public void sortDataByDate() {
        Arrays.sort(this.data);
    }
}

