/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.MatrixSeries;

public class NormalizedMatrixSeries
extends MatrixSeries {
    public static final double DEFAULT_SCALE_FACTOR = 1.0;
    private double m_scaleFactor = 1.0;
    private double m_totalSum = Double.MIN_VALUE;

    public NormalizedMatrixSeries(String string, int n, int n2) {
        super(string, n, n2);
    }

    public Number getItem(int n) {
        int n2 = this.getItemRow(n);
        int n3 = this.getItemColumn(n);
        double d = this.get(n2, n3) * this.m_scaleFactor;
        Double d2 = new Double(d / this.m_totalSum);
        return d2;
    }

    public void setScaleFactor(double d) {
        this.m_scaleFactor = d;
    }

    public double getScaleFactor() {
        return this.m_scaleFactor;
    }

    public void update(int n, int n2, double d) {
        this.m_totalSum -= this.get(n, n2);
        this.m_totalSum += d;
        super.update(n, n2, d);
    }

    public void zeroAll() {
        this.m_totalSum = 0.0;
        super.zeroAll();
    }
}

