/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BarChartDemo2
extends ApplicationFrame {
    public BarChartDemo2(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{1.0, 43.0, 35.0, 58.0, 54.0, 77.0, 71.0, 89.0}, {54.0, 75.0, 63.0, 83.0, 43.0, 46.0, 27.0, 13.0}, {41.0, 33.0, 22.0, 34.0, 62.0, 32.0, 42.0, 34.0}};
        return DatasetUtilities.createCategoryDataset("Series ", "Factor ", (double[][])dArrayArray);
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("Bar Chart Demo 2", "Category", "Score (%)", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.lightGray);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setMaxCategoryLabelWidthRatio(10.0f);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setRange(0.0, 100.0);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        BarChartDemo2 barChartDemo2 = new BarChartDemo2("Bar Chart Demo 2");
        barChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)barChartDemo2));
        barChartDemo2.setVisible(true);
    }
}

