/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.util.ArrayList;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.BoxAndWhiskerRenderer;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BoxAndWhiskerDemo
extends ApplicationFrame {
    public BoxAndWhiskerDemo(String string) {
        super(string);
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = this.createSampleDataset();
        CategoryAxis categoryAxis = new CategoryAxis("Type");
        NumberAxis numberAxis = new NumberAxis("Value");
        numberAxis.setAutoRangeIncludesZero(false);
        BoxAndWhiskerRenderer boxAndWhiskerRenderer = new BoxAndWhiskerRenderer();
        CategoryPlot categoryPlot = new CategoryPlot(boxAndWhiskerCategoryDataset, categoryAxis, numberAxis, boxAndWhiskerRenderer);
        JFreeChart jFreeChart = new JFreeChart("Box-and-Whisker Demo", new Font("SansSerif", 1, 14), categoryPlot, true);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(450, 270));
        this.setContentPane(chartPanel);
    }

    private BoxAndWhiskerCategoryDataset createSampleDataset() {
        DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = new DefaultBoxAndWhiskerCategoryDataset();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                for (int k = 0; k < 22; ++k) {
                    double d = 10.0 + Math.random() * 3.0;
                    arrayList.add(new Double(d));
                    double d2 = 11.25 + Math.random();
                    arrayList.add(new Double(d2));
                }
                defaultBoxAndWhiskerCategoryDataset.add(arrayList, (Comparable)((Object)("Series " + i)), (Comparable)((Object)(" Type " + j)));
            }
        }
        return defaultBoxAndWhiskerCategoryDataset;
    }

    public static void main(String[] stringArray) {
        BoxAndWhiskerDemo boxAndWhiskerDemo = new BoxAndWhiskerDemo("Box-and-Whisker Chart Demo");
        boxAndWhiskerDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)boxAndWhiskerDemo));
        boxAndWhiskerDemo.setVisible(true);
    }
}

