/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.HighLowDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CandlestickDemo
extends ApplicationFrame {
    public CandlestickDemo(String string) {
        super(string);
        HighLowDataset highLowDataset = DemoDatasetFactory.createHighLowDataset();
        JFreeChart jFreeChart = this.createChart(highLowDataset);
        jFreeChart.getXYPlot().setOrientation(PlotOrientation.VERTICAL);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(HighLowDataset highLowDataset) {
        JFreeChart jFreeChart = ChartFactory.createCandlestickChart("Candlestick Demo", "Time", "Value", highLowDataset, true);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        CandlestickDemo candlestickDemo = new CandlestickDemo("Candlestick Demo");
        candlestickDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)candlestickDemo));
        candlestickDemo.setVisible(true);
    }
}

