/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CyclicNumberAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.CyclicXYItemRenderer;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CyclicXYPlotDemo
extends ApplicationFrame
implements ActionListener {
    XYSeries series = new XYSeries("Random Data");
    long x = 0L;
    double y = 50.0;
    Timer timer;

    public CyclicXYPlotDemo(String string) {
        super(string);
        this.series.setMaximumItemCount(50);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(this.series);
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Cyclic XY Plot Demo", "X", "Y", xYSeriesCollection, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setDomainAxis(new CyclicNumberAxis(10.0, 0.0));
        xYPlot.setRenderer(new CyclicXYItemRenderer());
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setAutoRangeMinimumSize(1.0);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(400, 300));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)chartPanel, "Center");
        JButton jButton = new JButton("Start");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CyclicXYPlotDemo.this.timer.start();
            }
        });
        JButton jButton2 = new JButton("Stop");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CyclicXYPlotDemo.this.timer.stop();
            }
        });
        JButton jButton3 = new JButton("Step by step");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CyclicXYPlotDemo.this.actionPerformed(null);
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "South");
        this.setContentPane(jPanel);
        this.timer = new Timer(200, this);
    }

    public static void main(String[] stringArray) {
        CyclicXYPlotDemo cyclicXYPlotDemo = new CyclicXYPlotDemo("Cyclic XY Plot Demo");
        cyclicXYPlotDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)cyclicXYPlotDemo));
        cyclicXYPlotDemo.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double d = Math.random() * 10.0 - 5.0;
        if (d == -5.0) {
            d = 0.0;
        }
        this.y += d;
        this.series.add((double)this.x++ / 4.0, this.y);
    }
}

