/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Spacer;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYDifferenceRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class DifferenceChartDemo
extends ApplicationFrame {
    public DifferenceChartDemo(String string) {
        super(string);
        TimeSeries timeSeries = new TimeSeries("Random 1");
        TimeSeries timeSeries2 = new TimeSeries("Random 2");
        double d = 0.0;
        double d2 = 0.0;
        Day day = new Day();
        for (int i = 0; i < 200; ++i) {
            d = d + Math.random() - 0.5;
            d2 = d2 + Math.random() - 0.5;
            timeSeries.add((RegularTimePeriod)day, d);
            timeSeries2.add((RegularTimePeriod)day, d2);
            day = (Day)day.next();
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        timeSeriesCollection.addSeries(timeSeries2);
        JFreeChart jFreeChart = this.createChart(timeSeriesCollection);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Difference Chart Demo", "Time", "Value", xYDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setRenderer(new XYDifferenceRenderer(Color.green, Color.red, false));
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        DateAxis dateAxis = new DateAxis("Time");
        dateAxis.setLowerMargin(0.0);
        dateAxis.setUpperMargin(0.0);
        xYPlot.setDomainAxis(dateAxis);
        xYPlot.setForegroundAlpha(0.5f);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        DifferenceChartDemo differenceChartDemo = new DifferenceChartDemo("Difference Chart Demo");
        differenceChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)differenceChartDemo));
        differenceChartDemo.setVisible(true);
    }
}

