/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Window;
import java.io.IOException;
import java.util.Random;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.HistogramDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HistogramDemo
extends ApplicationFrame {
    static Random random = new Random();

    public HistogramDemo(String string) {
        super(string);
        IntervalXYDataset intervalXYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(intervalXYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private IntervalXYDataset createDataset() {
        HistogramDataset histogramDataset = new HistogramDataset();
        histogramDataset.setType(HistogramDataset.RELATIVE_FREQUENCY);
        histogramDataset.addSeries("H1", HistogramDemo.gaussianData(1000, 3.0), 20);
        histogramDataset.addSeries("H0", HistogramDemo.gaussianData(1000, 0.0), 20);
        return histogramDataset;
    }

    private JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createHistogram("Histogram Demo", null, null, intervalXYDataset, PlotOrientation.VERTICAL, true, false, false);
        jFreeChart.getXYPlot().setForegroundAlpha(0.75f);
        return jFreeChart;
    }

    private static double[] gaussianData(int n, double d) {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = random.nextGaussian() + d;
        }
        return dArray;
    }

    public static void main(String[] stringArray) throws IOException {
        HistogramDemo histogramDemo = new HistogramDemo("Histogram Demo");
        histogramDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)histogramDemo));
        histogramDemo.setVisible(true);
    }
}

