/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.labels.IntervalCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.IntervalBarRenderer;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.chart.renderer.ItemLabelPosition;
import org.jfree.data.DefaultIntervalCategoryDataset;
import org.jfree.ui.TextAnchor;

public class IntervalBarChartDemo1 {
    private static final String[] CATEGORIES = new String[]{"1", "3", "5", "10", "20"};
    private static Font labelFont = null;
    private static Font titleFont = null;
    private JFreeChart chart = null;

    public IntervalBarChartDemo1() {
        DefaultIntervalCategoryDataset defaultIntervalCategoryDataset = null;
        double[][] dArrayArray = new double[][]{{-0.0315, 0.0159, 0.0306, 0.0453, 0.0557}};
        double[][] dArrayArray2 = new double[][]{{0.1931, 0.1457, 0.131, 0.1163, 0.1059}};
        defaultIntervalCategoryDataset = new DefaultIntervalCategoryDataset(dArrayArray, dArrayArray2);
        defaultIntervalCategoryDataset.setCategoryKeys((Comparable[])CATEGORIES);
        String string = "Strategie Sicherheit";
        String string2 = "Zeitraum (in Jahren)";
        String string3 = "Performance";
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        categoryAxis.setLabelFont(titleFont);
        categoryAxis.setTickLabelFont(labelFont);
        categoryAxis.setTickMarksVisible(false);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setLabelFont(titleFont);
        numberAxis.setTickLabelFont(labelFont);
        numberAxis.setRange(-0.2, 0.4);
        DecimalFormat decimalFormat = new DecimalFormat("0.##%");
        numberAxis.setTickUnit(new NumberTickUnit(0.05, decimalFormat));
        IntervalBarRenderer intervalBarRenderer = new IntervalBarRenderer();
        intervalBarRenderer.setSeriesPaint(0, new Color(51, 102, 153));
        intervalBarRenderer.setItemLabelGenerator(new IntervalCategoryItemLabelGenerator());
        intervalBarRenderer.setItemLabelsVisible(true);
        intervalBarRenderer.setItemLabelPaint(Color.white);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
        intervalBarRenderer.setPositiveItemLabelPosition(itemLabelPosition);
        CategoryPlot categoryPlot = new CategoryPlot(defaultIntervalCategoryDataset, categoryAxis, numberAxis, intervalBarRenderer);
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setOutlinePaint(Color.white);
        categoryPlot.setOrientation(PlotOrientation.VERTICAL);
        this.chart = new JFreeChart(string, titleFont, categoryPlot, false);
        this.chart.setBackgroundPaint(Color.white);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public static void main(String[] stringArray) {
        IntervalBarChartDemo1 intervalBarChartDemo1 = new IntervalBarChartDemo1();
        JFreeChart jFreeChart = intervalBarChartDemo1.getChart();
        ChartFrame chartFrame = new ChartFrame("Interval Bar Chart Demo", jFreeChart);
        chartFrame.pack();
        chartFrame.setVisible(true);
    }

    static {
        labelFont = new Font("Helvetica", 0, 10);
        titleFont = new Font("Helvetica", 1, 14);
    }
}

