/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.DescriptionPanel;
import org.jfree.chart.demo.JFreeChartDemoBase;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.about.AboutFrame;

public class JFreeChartDemo
extends JFrame
implements ActionListener,
WindowListener {
    public static final String EXIT_COMMAND = "EXIT";
    public static final String ABOUT_COMMAND = "ABOUT";
    private static final JFreeChartDemoBase DEMO = new JFreeChartDemoBase();
    private static final String[][] CHART_COMMANDS = JFreeChartDemoBase.CHART_COMMANDS;
    private ResourceBundle resources;
    private ChartFrame[] frame = new ChartFrame[CHART_COMMANDS.length];
    private JPanel[] panels = null;
    public static final Dimension PREFERRED_SIZE = new Dimension(780, 400);
    private AboutFrame aboutFrame;

    public JFreeChartDemo() {
        super(JFreeChart.INFO.getName() + " " + JFreeChart.INFO.getVersion() + " Demo");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JFreeChartDemo.this.dispose();
                System.exit(0);
            }
        });
        this.resources = DEMO.getResources();
        JMenuBar jMenuBar = this.createMenuBar(this.resources);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.createTabbedPane(this.resources));
        this.setContentPane(jPanel);
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(EXIT_COMMAND)) {
            this.attemptExit();
        } else if (string.equals(ABOUT_COMMAND)) {
            this.about();
        } else {
            int n = -1;
            int n2 = CHART_COMMANDS.length;
            while (n2 > 0) {
                if (!string.equals(CHART_COMMANDS[--n2][0])) continue;
                n = n2;
                n2 = 0;
            }
            if (n >= 0 && n < this.frame.length) {
                if (this.frame[n] == null) {
                    block11: {
                        DEMO.getChart(n);
                        String string2 = this.resources.getString(CHART_COMMANDS[n][2] + ".title");
                        this.frame[n] = new ChartFrame(string2, DEMO.getChart(n));
                        this.frame[n].getChartPanel().setPreferredSize(new Dimension(500, 270));
                        this.frame[n].pack();
                        RefineryUtilities.positionFrameRandomly((Window)this.frame[n]);
                        try {
                            string2 = this.resources.getString(CHART_COMMANDS[n][2] + ".zoom");
                            if (string2 != null && string2.toLowerCase().equals("true")) {
                                ChartPanel chartPanel = this.frame[n].getChartPanel();
                                chartPanel.setMouseZoomable(true);
                                chartPanel.setHorizontalAxisTrace(true);
                                chartPanel.setVerticalAxisTrace(true);
                            }
                        }
                        catch (Exception exception) {
                            if (exception.getMessage().indexOf("MissingResourceException") != 0) break block11;
                            exception.printStackTrace();
                        }
                    }
                    this.frame[n].show();
                } else {
                    this.frame[n].show();
                    this.frame[n].requestFocus();
                }
            }
        }
    }

    private void attemptExit() {
        String string = this.resources.getString("dialog.exit.title");
        String string2 = this.resources.getString("dialog.exit.message");
        int n = JOptionPane.showConfirmDialog(this, string2, string, 0, 3);
        if (n == 0) {
            this.dispose();
            System.exit(0);
        }
    }

    private void about() {
        String string = this.resources.getString("about.title");
        if (this.aboutFrame == null) {
            this.aboutFrame = new AboutFrame(string, JFreeChart.INFO);
            this.aboutFrame.pack();
            RefineryUtilities.centerFrameOnScreen((Window)this.aboutFrame);
        }
        this.aboutFrame.show();
        this.aboutFrame.requestFocus();
    }

    public static void main(String[] stringArray) {
        JFreeChartDemo jFreeChartDemo = new JFreeChartDemo();
        jFreeChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)jFreeChartDemo);
        jFreeChartDemo.setVisible(true);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this.aboutFrame) {
            this.aboutFrame = null;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private JMenuBar createMenuBar(ResourceBundle resourceBundle) {
        JMenuBar jMenuBar = new JMenuBar();
        String string = resourceBundle.getString("menu.file");
        Character c = (Character)resourceBundle.getObject("menu.file.mnemonic");
        JMenu jMenu = new JMenu(string, true);
        jMenu.setMnemonic(c.charValue());
        string = resourceBundle.getString("menu.file.exit");
        c = (Character)resourceBundle.getObject("menu.file.exit.mnemonic");
        JMenuItem jMenuItem = new JMenuItem(string, c.charValue());
        jMenuItem.setActionCommand(EXIT_COMMAND);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        string = resourceBundle.getString("menu.help");
        c = (Character)resourceBundle.getObject("menu.help.mnemonic");
        JMenu jMenu2 = new JMenu(string);
        jMenu2.setMnemonic(c.charValue());
        string = resourceBundle.getString("menu.help.about");
        c = (Character)resourceBundle.getObject("menu.help.about.mnemonic");
        JMenuItem jMenuItem2 = new JMenuItem(string, c.charValue());
        jMenuItem2.setActionCommand(ABOUT_COMMAND);
        jMenuItem2.addActionListener(this);
        jMenu2.add(jMenuItem2);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    private JTabbedPane createTabbedPane(ResourceBundle resourceBundle) {
        Font font = new Font("Dialog", 0, 12);
        JTabbedPane jTabbedPane = new JTabbedPane();
        int n = 1;
        Vector<String> vector = new Vector<String>(0);
        String string = null;
        while (n > 0) {
            try {
                string = resourceBundle.getString("tabs." + n);
                if (string != null) {
                    vector.add(string);
                } else {
                    n = -1;
                }
                ++n;
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        if (vector.size() == 0) {
            vector.add("Default");
        }
        n = vector.size();
        this.panels = new JPanel[n];
        String[] stringArray = new String[n];
        --n;
        while (n >= 0) {
            stringArray[n] = string = vector.get(n).toString();
            --n;
        }
        vector.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            this.panels[i] = new JPanel();
            this.panels[i].setLayout((LayoutManager)new LCBLayout(20));
            this.panels[i].setPreferredSize(new Dimension(360, 20));
            this.panels[i].setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jTabbedPane.add(stringArray[i], new JScrollPane(this.panels[i]));
        }
        String string2 = resourceBundle.getString("charts.display");
        String string3 = null;
        for (int i = 0; i <= CHART_COMMANDS.length - 1; ++i) {
            try {
                string3 = resourceBundle.getString(CHART_COMMANDS[i][2] + ".usage");
            }
            catch (Exception exception) {
                string3 = null;
            }
            if (string3 != null && !string3.equalsIgnoreCase("All") && !string3.equalsIgnoreCase("Swing")) continue;
            string = resourceBundle.getString(CHART_COMMANDS[i][2] + ".title");
            String string4 = resourceBundle.getString(CHART_COMMANDS[i][2] + ".description");
            try {
                n = Integer.parseInt(resourceBundle.getString(CHART_COMMANDS[i][2] + ".tab"));
                --n;
            }
            catch (Exception exception) {
                System.err.println("Demo : Error retrieving tab identifier for chart " + CHART_COMMANDS[i][2]);
                System.err.println("Demo : Error = " + exception.getMessage());
                n = 0;
            }
            if (n < 0 || n >= this.panels.length) {
                n = 0;
            }
            System.out.println("Demo : adding " + CHART_COMMANDS[i][0] + " to panel " + n);
            this.panels[n].add(RefineryUtilities.createJLabel((String)string, (Font)font));
            this.panels[n].add(new DescriptionPanel(new JTextArea(string4)));
            JButton jButton = RefineryUtilities.createJButton((String)string2, (Font)font);
            jButton.setActionCommand(CHART_COMMANDS[i][0]);
            jButton.addActionListener(this);
            this.panels[n].add(jButton);
        }
        return jTabbedPane;
    }
}

