/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Spacer;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class MultipleAxisDemo1
extends ApplicationFrame {
    public MultipleAxisDemo1(String string) {
        super(string);
        JFreeChart jFreeChart = this.createChart();
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(600, 270));
        chartPanel.setHorizontalZoom(true);
        chartPanel.setVerticalZoom(true);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart() {
        XYDataset xYDataset = this.createDataset("Series 1", 100.0, new Minute(), 200);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Multiple Axis Demo 1", "Time of Day", "Primary Range Axis", xYDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        jFreeChart.addSubtitle(new TextTitle("Four datasets and four range axes."));
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setOrientation(PlotOrientation.VERTICAL);
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)xYPlot.getRenderer();
        standardXYItemRenderer.setPaint(Color.black);
        NumberAxis numberAxis = new NumberAxis("Range Axis 2");
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setLabelPaint(Color.red);
        numberAxis.setTickLabelPaint(Color.red);
        xYPlot.setSecondaryRangeAxis(0, numberAxis);
        xYPlot.setSecondaryRangeAxisLocation(0, AxisLocation.BOTTOM_OR_LEFT);
        XYDataset xYDataset2 = this.createDataset("Series 2", 1000.0, new Minute(), 170);
        xYPlot.setSecondaryDataset(0, xYDataset2);
        xYPlot.mapSecondaryDatasetToRangeAxis(0, new Integer(0));
        xYPlot.setSecondaryRenderer(0, new StandardXYItemRenderer());
        xYPlot.getSecondaryRenderer(0).setSeriesPaint(0, Color.red);
        NumberAxis numberAxis2 = new NumberAxis("Range Axis 3");
        numberAxis2.setLabelPaint(Color.blue);
        numberAxis2.setTickLabelPaint(Color.blue);
        xYPlot.setSecondaryRangeAxis(1, numberAxis2);
        XYDataset xYDataset3 = this.createDataset("Series 3", 10000.0, new Minute(), 170);
        xYPlot.setSecondaryDataset(1, xYDataset3);
        xYPlot.mapSecondaryDatasetToRangeAxis(1, new Integer(1));
        xYPlot.setSecondaryRenderer(1, new StandardXYItemRenderer());
        xYPlot.getSecondaryRenderer(1).setSeriesPaint(0, Color.blue);
        NumberAxis numberAxis3 = new NumberAxis("Range Axis 4");
        numberAxis3.setLabelPaint(Color.green);
        numberAxis3.setTickLabelPaint(Color.green);
        xYPlot.setSecondaryRangeAxis(2, numberAxis3);
        XYDataset xYDataset4 = this.createDataset("Series 4", 25.0, new Minute(), 200);
        xYPlot.setSecondaryDataset(2, xYDataset4);
        xYPlot.mapSecondaryDatasetToRangeAxis(2, new Integer(2));
        xYPlot.setSecondaryRenderer(2, new StandardXYItemRenderer());
        xYPlot.getSecondaryRenderer(2).setSeriesPaint(0, Color.green);
        return jFreeChart;
    }

    private XYDataset createDataset(String string, double d, RegularTimePeriod regularTimePeriod, int n) {
        TimeSeries timeSeries = new TimeSeries(string, regularTimePeriod.getClass());
        RegularTimePeriod regularTimePeriod2 = regularTimePeriod;
        double d2 = d;
        for (int i = 0; i < n; ++i) {
            timeSeries.add(regularTimePeriod2, d2);
            regularTimePeriod2 = regularTimePeriod2.next();
            d2 *= 1.0 + (Math.random() - 0.495) / 10.0;
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        return timeSeriesCollection;
    }

    public static void main(String[] stringArray) {
        MultipleAxisDemo1 multipleAxisDemo1 = new MultipleAxisDemo1("Multiple Axis Demo 1");
        multipleAxisDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)multipleAxisDemo1));
        multipleAxisDemo1.setVisible(true);
    }
}

