/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.text.NumberFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DataUtilities;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.SortOrder;

public class ParetoChartDemo
extends ApplicationFrame {
    public ParetoChartDemo(String string) {
        super(string);
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.addValue((Comparable)((Object)"C"), new Integer(4843));
        defaultKeyedValues.addValue((Comparable)((Object)"C++"), new Integer(2098));
        defaultKeyedValues.addValue((Comparable)((Object)"C#"), new Integer(26));
        defaultKeyedValues.addValue((Comparable)((Object)"Java"), new Integer(1901));
        defaultKeyedValues.addValue((Comparable)((Object)"Perl"), new Integer(2507));
        defaultKeyedValues.addValue((Comparable)((Object)"PHP"), new Integer(1689));
        defaultKeyedValues.addValue((Comparable)((Object)"Python"), new Integer(948));
        defaultKeyedValues.addValue((Comparable)((Object)"Ruby"), new Integer(100));
        defaultKeyedValues.addValue((Comparable)((Object)"SQL"), new Integer(263));
        defaultKeyedValues.addValue((Comparable)((Object)"Unix Shell"), new Integer(485));
        defaultKeyedValues.sortByValues(SortOrder.DESCENDING);
        KeyedValues keyedValues = DataUtilities.getCumulativePercentages(defaultKeyedValues);
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Languages", defaultKeyedValues);
        JFreeChart jFreeChart = ChartFactory.createBarChart("Freshmeat Software Projects", "Language", "Projects", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.addSubtitle(new TextTitle("By Programming Language"));
        jFreeChart.addSubtitle(new TextTitle("As at 5 March 2003"));
        jFreeChart.setBackgroundPaint(new Color(0xBBBBDD));
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setLowerMargin(0.02);
        categoryAxis.setUpperMargin(0.02);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        CategoryDataset categoryDataset2 = DatasetUtilities.createCategoryDataset("Cumulative", keyedValues);
        NumberAxis numberAxis2 = new NumberAxis("Percent");
        numberAxis2.setNumberFormatOverride(NumberFormat.getPercentInstance());
        categoryPlot.setSecondaryRangeAxis(0, numberAxis2);
        categoryPlot.setSecondaryDataset(0, categoryDataset2);
        categoryPlot.setSecondaryRenderer(0, lineAndShapeRenderer);
        categoryPlot.mapSecondaryDatasetToRangeAxis(0, new Integer(0));
        categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(550, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        ParetoChartDemo paretoChartDemo = new ParetoChartDemo("Pareto Chart Demo");
        paretoChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)paretoChartDemo));
        paretoChartDemo.setVisible(true);
    }
}

