/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.XYDataset;

public class SampleXYDataset
extends AbstractSeriesDataset
implements XYDataset {
    private double translate = 0.0;

    public double getTranslate() {
        return this.translate;
    }

    public void setTranslate(double d) {
        this.translate = d;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public Number getXValue(int n, int n2) {
        return new Double(-10.0 + this.translate + (double)n2 / 10.0);
    }

    public Number getYValue(int n, int n2) {
        if (n == 0) {
            return new Double(Math.cos(-10.0 + this.translate + (double)n2 / 10.0));
        }
        return new Double(2.0 * Math.sin(-10.0 + this.translate + (double)n2 / 10.0));
    }

    public int getSeriesCount() {
        return 2;
    }

    public String getSeriesName(int n) {
        if (n == 0) {
            return "y = cosine(x)";
        }
        if (n == 1) {
            return "y = 2*sine(x)";
        }
        return "Error";
    }

    public int getItemCount(int n) {
        return 200;
    }
}

