/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.lang.reflect.Array;
import java.util.Vector;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.XisSymbolic;
import org.jfree.data.YisSymbolic;

public class SampleXYSymbolicDataset
extends AbstractSeriesDataset
implements XYDataset,
XisSymbolic,
YisSymbolic {
    private String[] seriesName;
    private int[] item;
    private int serie;
    private Integer[][] xValues;
    private Integer[][] yValues;
    private String[] xSymbolicValues;
    private String[] ySymbolicValues;
    private String datasetName;

    public SampleXYSymbolicDataset(String string, Integer[][] integerArray, Integer[][] integerArray2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.datasetName = string;
        this.xValues = integerArray;
        this.yValues = integerArray2;
        this.xSymbolicValues = stringArray;
        this.ySymbolicValues = stringArray2;
        this.serie = integerArray.length;
        this.item = new int[this.serie];
        for (int i = 0; i < this.serie; ++i) {
            this.item[i] = integerArray[i].length;
        }
        this.seriesName = stringArray3;
    }

    public Number getXValue(int n, int n2) {
        return this.xValues[n][n2];
    }

    public Number getYValue(int n, int n2) {
        return this.yValues[n][n2];
    }

    public void setXValue(int n, int n2, Number number) {
        this.xValues[n][n2] = (Integer)number;
    }

    public void setYValue(int n, int n2, Number number) {
        this.yValues[n][n2] = (Integer)number;
    }

    public int getSeriesCount() {
        return this.serie;
    }

    public String getSeriesName(int n) {
        if (this.seriesName != null) {
            return this.seriesName[n];
        }
        return this.datasetName + n;
    }

    public int getItemCount(int n) {
        return this.item[n];
    }

    public String[] getXSymbolicValues() {
        return this.xSymbolicValues;
    }

    public String[] getYSymbolicValues() {
        return this.ySymbolicValues;
    }

    public void setXSymbolicValues(String[] stringArray) {
        this.xSymbolicValues = stringArray;
    }

    public void setYSymbolicValues(String[] stringArray) {
        this.ySymbolicValues = stringArray;
    }

    public String getXSymbolicValue(int n, int n2) {
        Integer n3 = (Integer)this.getXValue(n, n2);
        return this.getXSymbolicValue(n3);
    }

    public String getYSymbolicValue(int n, int n2) {
        Integer n3 = (Integer)this.getYValue(n, n2);
        return this.getYSymbolicValue(n3);
    }

    public String getXSymbolicValue(Integer n) {
        return this.xSymbolicValues[n];
    }

    public String getYSymbolicValue(Integer n) {
        return this.ySymbolicValues[n];
    }

    public static String[] combineYSymbolicDataset(YisSymbolic yisSymbolic, YisSymbolic yisSymbolic2) {
        int n;
        SampleXYSymbolicDataset sampleXYSymbolicDataset = (SampleXYSymbolicDataset)yisSymbolic;
        SampleXYSymbolicDataset sampleXYSymbolicDataset2 = (SampleXYSymbolicDataset)yisSymbolic2;
        String[] stringArray = sampleXYSymbolicDataset.getYSymbolicValues();
        String[] stringArray2 = sampleXYSymbolicDataset2.getYSymbolicValues();
        int n2 = stringArray.length;
        int n3 = stringArray2.length;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < n2; ++n) {
            vector.add(stringArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            if (vector.contains(stringArray2[n])) continue;
            vector.add(stringArray2[n]);
        }
        for (int i = 0; i < sampleXYSymbolicDataset2.getSeriesCount(); ++i) {
            for (int j = 0; j < sampleXYSymbolicDataset2.getItemCount(i); ++j) {
                n = vector.indexOf(sampleXYSymbolicDataset2.getYSymbolicValue(i, j));
                sampleXYSymbolicDataset2.setYValue(i, j, new Integer(n));
            }
        }
        String[] stringArray3 = new String[vector.size()];
        vector.toArray(stringArray3);
        sampleXYSymbolicDataset.setYSymbolicValues(stringArray3);
        sampleXYSymbolicDataset2.setYSymbolicValues(stringArray3);
        return stringArray3;
    }

    public static String[] combineXSymbolicDataset(XisSymbolic xisSymbolic, XisSymbolic xisSymbolic2) {
        int n;
        SampleXYSymbolicDataset sampleXYSymbolicDataset = (SampleXYSymbolicDataset)xisSymbolic;
        SampleXYSymbolicDataset sampleXYSymbolicDataset2 = (SampleXYSymbolicDataset)xisSymbolic2;
        String[] stringArray = sampleXYSymbolicDataset.getXSymbolicValues();
        String[] stringArray2 = sampleXYSymbolicDataset2.getXSymbolicValues();
        int n2 = stringArray.length;
        int n3 = stringArray2.length;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < n2; ++n) {
            vector.add(stringArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            if (vector.contains(stringArray2[n])) continue;
            vector.add(stringArray2[n]);
        }
        for (int i = 0; i < sampleXYSymbolicDataset2.getSeriesCount(); ++i) {
            for (int j = 0; j < sampleXYSymbolicDataset2.getItemCount(i); ++j) {
                n = vector.indexOf(sampleXYSymbolicDataset2.getXSymbolicValue(i, j));
                sampleXYSymbolicDataset2.setXValue(i, j, new Integer(n));
            }
        }
        String[] stringArray3 = new String[vector.size()];
        vector.toArray(stringArray3);
        sampleXYSymbolicDataset.setXSymbolicValues(stringArray3);
        sampleXYSymbolicDataset2.setXSymbolicValues(stringArray3);
        return stringArray3;
    }

    public Object clone() {
        String string = new String(this.datasetName);
        Integer[][] integerArray = (Integer[][])SampleXYSymbolicDataset.cloneArray(this.xValues);
        Integer[][] integerArray2 = (Integer[][])SampleXYSymbolicDataset.cloneArray(this.yValues);
        String[] stringArray = (String[])SampleXYSymbolicDataset.cloneArray(this.xSymbolicValues);
        String[] stringArray2 = (String[])SampleXYSymbolicDataset.cloneArray(this.ySymbolicValues);
        String[] stringArray3 = (String[])SampleXYSymbolicDataset.cloneArray(this.seriesName);
        return new SampleXYSymbolicDataset(string, integerArray, integerArray2, stringArray, stringArray2, stringArray3);
    }

    private static Object cloneArray(Object object) {
        if (object == null) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object;
        }
        int n = Array.getLength(object);
        Object[] objectArray = (Object[])Array.newInstance(clazz.getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            objectArray[i] = object2.getClass().isArray() ? SampleXYSymbolicDataset.cloneArray(object2) : object2;
        }
        return objectArray;
    }
}

