/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.lang.reflect.Array;
import java.util.Vector;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.YisSymbolic;

public class SampleYSymbolicDataset
extends AbstractSeriesDataset
implements XYDataset,
YisSymbolic {
    private static final int DEFAULT_SERIES_COUNT = 1;
    private static final int DEFAULT_ITEM_COUNT = 50;
    private int serie;
    private int item;
    private String[] serieNames;
    private Double[][] xValues;
    private Integer[][] yValues;
    private String[] ySymbolicValues;
    private String datasetName;

    public SampleYSymbolicDataset(String string, int n, String[] stringArray) {
        this(string, n, stringArray, 1, 50, null);
    }

    public SampleYSymbolicDataset(String string, int n, String[] stringArray, int n2, int n3, String[] stringArray2) {
        this.datasetName = string;
        this.ySymbolicValues = stringArray;
        this.serie = n2;
        this.item = n3;
        this.serieNames = stringArray2;
        this.xValues = new Double[n2][n3];
        this.yValues = new Integer[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = Math.random() * (double)n;
                double d2 = Math.random() * (double)stringArray.length;
                this.xValues[i][j] = new Double(d);
                this.yValues[i][j] = new Integer((int)d2);
            }
        }
    }

    public SampleYSymbolicDataset(String string, Double[][] doubleArray, Integer[][] integerArray, String[] stringArray, int n, int n2, String[] stringArray2) {
        this.datasetName = string;
        this.xValues = doubleArray;
        this.yValues = integerArray;
        this.ySymbolicValues = stringArray;
        this.serie = n;
        this.item = n2;
        this.serieNames = stringArray2;
    }

    public Number getXValue(int n, int n2) {
        return this.xValues[n][n2];
    }

    public Number getYValue(int n, int n2) {
        return this.yValues[n][n2];
    }

    public void setYValue(int n, int n2, Number number) {
        this.yValues[n][n2] = (Integer)number;
    }

    public int getSeriesCount() {
        return this.serie;
    }

    public String getSeriesName(int n) {
        if (this.serieNames != null) {
            return this.serieNames[n];
        }
        return this.datasetName + n;
    }

    public int getItemCount(int n) {
        return this.item;
    }

    public String[] getYSymbolicValues() {
        return this.ySymbolicValues;
    }

    public void setYSymbolicValues(String[] stringArray) {
        this.ySymbolicValues = stringArray;
    }

    public String getYSymbolicValue(int n, int n2) {
        Integer n3 = (Integer)this.getYValue(n, n2);
        return this.getYSymbolicValue(n3);
    }

    public String getYSymbolicValue(Integer n) {
        return this.ySymbolicValues[n];
    }

    public static String[] combineYSymbolicDataset(YisSymbolic yisSymbolic, YisSymbolic yisSymbolic2) {
        int n;
        SampleYSymbolicDataset sampleYSymbolicDataset = (SampleYSymbolicDataset)yisSymbolic;
        SampleYSymbolicDataset sampleYSymbolicDataset2 = (SampleYSymbolicDataset)yisSymbolic2;
        String[] stringArray = sampleYSymbolicDataset.getYSymbolicValues();
        String[] stringArray2 = sampleYSymbolicDataset2.getYSymbolicValues();
        int n2 = stringArray.length;
        int n3 = stringArray2.length;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < n2; ++n) {
            vector.add(stringArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            if (vector.contains(stringArray2[n])) continue;
            vector.add(stringArray2[n]);
        }
        for (int i = 0; i < sampleYSymbolicDataset2.getSeriesCount(); ++i) {
            for (int j = 0; j < sampleYSymbolicDataset2.getItemCount(i); ++j) {
                n = vector.indexOf(sampleYSymbolicDataset2.getYSymbolicValue(i, j));
                sampleYSymbolicDataset2.setYValue(i, j, new Integer(n));
            }
        }
        String[] stringArray3 = new String[vector.size()];
        vector.toArray(stringArray3);
        sampleYSymbolicDataset.setYSymbolicValues(stringArray3);
        sampleYSymbolicDataset2.setYSymbolicValues(stringArray3);
        return stringArray3;
    }

    public Object clone() {
        String string = new String(this.datasetName);
        Double[][] doubleArray = (Double[][])SampleYSymbolicDataset.cloneArray(this.xValues);
        Integer[][] integerArray = (Integer[][])SampleYSymbolicDataset.cloneArray(this.yValues);
        String[] stringArray = (String[])SampleYSymbolicDataset.cloneArray(this.ySymbolicValues);
        int n = this.serie;
        int n2 = this.item;
        String[] stringArray2 = (String[])SampleYSymbolicDataset.cloneArray(this.serieNames);
        return new SampleYSymbolicDataset(string, doubleArray, integerArray, stringArray, n, n2, stringArray2);
    }

    private static Object cloneArray(Object object) {
        if (object == null) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object;
        }
        int n = Array.getLength(object);
        Object[] objectArray = (Object[])Array.newInstance(clazz.getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            objectArray[i] = object2.getClass().isArray() ? SampleYSymbolicDataset.cloneArray(object2) : object2;
        }
        return objectArray;
    }
}

