/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import org.jfree.data.AbstractDataset;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.IntervalXYDataset;

public class SimpleIntervalXYDataset2
extends AbstractDataset
implements IntervalXYDataset {
    private Double[] yStart;
    private Double[] yEnd = new Double[3];
    private Double[] x = new Double[3];

    public SimpleIntervalXYDataset2(int n) {
        this.x = new Double[n];
        this.yStart = new Double[n];
        this.yEnd = new Double[n];
        double d = 100.0;
        for (int i = 1; i <= n; ++i) {
            this.x[i - 1] = new Double(i);
            this.yStart[i - 1] = new Double(d *= 1.0 + (Math.random() / 10.0 - 0.05));
            this.yEnd[i - 1] = new Double(this.yStart[i - 1] + Math.random() * 30.0);
        }
    }

    public int getSeriesCount() {
        return 1;
    }

    public String getSeriesName(int n) {
        return "Series 1";
    }

    public int getItemCount(int n) {
        return this.x.length;
    }

    public Number getXValue(int n, int n2) {
        return this.x[n2];
    }

    public Number getYValue(int n, int n2) {
        return this.yEnd[n2];
    }

    public Number getStartXValue(int n, int n2) {
        return this.x[n2];
    }

    public Number getEndXValue(int n, int n2) {
        return this.x[n2];
    }

    public Number getStartYValue(int n, int n2) {
        return this.yStart[n2];
    }

    public Number getEndYValue(int n, int n2) {
        return this.yEnd[n2];
    }

    public void addChangeListener(DatasetChangeListener datasetChangeListener) {
    }

    public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
    }
}

