/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline;

import com.artenum.cassandra.pipeline.ConnectivityListener;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.VtkObjectAdapter;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.vtk.CassandraView;
import com.artenum.cassandra.vtk.DefaultAxes;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import vtk.vtkActor;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkProp;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;
import vtk.vtkTextActor;

public class SimplePipeLineManager
extends Observable
implements PipeLineManager {
    private CassandraView view;
    private ArrayList connectivityListener;
    private Hashtable vtkObjectHashtable;
    private VtkObjectListModel actorList;
    private VtkObjectListModel mapperList;
    private VtkObjectListModel datasetList;
    private VtkObjectListModel filterList;
    private VtkObjectListModel lookupTableList;
    private VtkObjectListModel scalarBarList;
    private VtkObjectListModel txtActorList;
    private Integer vtkObjectIndex = new Integer(0);
    private int pluginNumber = 1;
    private int actorNumber = 1;
    private int sourceNumber = 1;
    private int mapperNumber = 1;
    private int filterNumber = 1;
    private int lookupNumber = 1;
    private int scalarBarNumber = 1;
    private int txtActorNumber = 1;
    private DefaultAxes axes;

    public SimplePipeLineManager() {
        this.view = new CassandraView();
        this.vtkObjectHashtable = new Hashtable();
        this.actorList = new VtkObjectListModel(1);
        this.mapperList = new VtkObjectListModel(2);
        this.datasetList = new VtkObjectListModel(3);
        this.filterList = new VtkObjectListModel(4);
        this.lookupTableList = new VtkObjectListModel(5);
        this.scalarBarList = new VtkObjectListModel(6);
        this.txtActorList = new VtkObjectListModel(7);
        this.axes = new DefaultAxes(this);
        this.connectivityListener = new ArrayList();
    }

    public synchronized void addVtkFile(File file) {
        if (!file.exists()) {
            System.err.println("File does not exist: " + file.getAbsolutePath());
            return;
        }
        vtkDataSetReader vtkDataSetReader2 = new vtkDataSetReader();
        vtkDataSetReader2.SetFileName(file.getAbsolutePath());
        vtkDataSetReader2.Update();
        vtkDataSetMapper vtkDataSetMapper2 = new vtkDataSetMapper();
        vtkDataSetMapper2.SetInput(vtkDataSetReader2.GetOutput());
        vtkDataSetMapper2.Update();
        vtkActor vtkActor2 = new vtkActor();
        vtkActor2.SetMapper((vtkMapper)vtkDataSetMapper2);
        this.addDataSet(vtkDataSetReader2.GetOutput(), file.getName());
        this.addMapper(vtkDataSetMapper2, file.getName());
        this.setActorVisible(this.addActor(vtkActor2, file.getName()), true);
        if (vtkDataSetReader2.GetOutput().GetScalarRange() != null) {
            vtkLookupTable vtkLookupTable2 = new vtkLookupTable();
            vtkLookupTable2.SetHueRange(0.66667, 0.0);
            vtkLookupTable2.SetTableRange(vtkDataSetReader2.GetOutput().GetScalarRange());
            vtkLookupTable2.Build();
            vtkDataSetMapper2.SetLookupTable((vtkScalarsToColors)vtkLookupTable2);
            vtkDataSetMapper2.SetScalarRange(vtkDataSetReader2.GetOutput().GetScalarRange());
            vtkScalarBarActor vtkScalarBarActor2 = new vtkScalarBarActor();
            vtkScalarBarActor2.SetLookupTable((vtkScalarsToColors)vtkLookupTable2);
            this.addLookupTable(vtkLookupTable2, file.getName());
            this.setActorVisible(this.addScalarBar(vtkScalarBarActor2, file.getName()), true);
        }
    }

    public void setActorVisible(Integer n, boolean bl) {
        this.setActorVisible((VtkObject)this.vtkObjectHashtable.get(n), bl);
    }

    public void setActorVisible(VtkObject vtkObject, boolean bl) {
        if (vtkObject.getType() == 1 || vtkObject.getType() == 7 || vtkObject.getType() == 6) {
            if (!vtkObject.isValide()) {
                return;
            }
            vtkObject.getMetaData().put("ACTOR_VISIBLE", Boolean.toString(bl));
            if (vtkObject.getVtkObject() instanceof vtkActor) {
                if (bl) {
                    this.view.GetRenderer().AddActor((vtkProp)vtkObject.getVtkObject());
                } else {
                    this.view.GetRenderer().RemoveActor((vtkProp)vtkObject.getVtkObject());
                }
            } else if (bl) {
                this.view.GetRenderer().AddActor2D((vtkProp)vtkObject.getVtkObject());
            } else {
                this.view.GetRenderer().RemoveActor2D((vtkProp)vtkObject.getVtkObject());
            }
        }
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
    }

    public VtkObject getVtkObject(Integer n) {
        return (VtkObject)this.vtkObjectHashtable.get(n);
    }

    public Integer getNextVtkObjectId() {
        this.vtkObjectIndex = new Integer(this.vtkObjectIndex + 1);
        return this.vtkObjectIndex;
    }

    public VtkObjectListModel getActorList() {
        return this.actorList;
    }

    public VtkObjectListModel getDataSetList() {
        return this.datasetList;
    }

    public VtkObjectListModel getFilterList() {
        return this.filterList;
    }

    public VtkObjectListModel getMapperList() {
        return this.mapperList;
    }

    public VtkObjectListModel getLookupTableList() {
        return this.lookupTableList;
    }

    public VtkObjectListModel getScalarBarList() {
        return this.scalarBarList;
    }

    public VtkObjectListModel getTextActorList() {
        return this.txtActorList;
    }

    public synchronized VtkObject addActor(Object object, String string) {
        int n = this.actorNumber++;
        String string2 = string + " (" + n + ")";
        VtkObjectAdapter vtkObjectAdapter = new VtkObjectAdapter(object, 1, string2, this.getNextVtkObjectId());
        vtkObjectAdapter.setLocalTypeId(n);
        this.vtkObjectHashtable.put(vtkObjectAdapter.getId(), vtkObjectAdapter);
        this.actorList.addVtkObject((VtkObject)vtkObjectAdapter);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObjectAdapter;
    }

    public synchronized VtkObject addMapper(Object object, String string) {
        int n = this.mapperNumber++;
        String string2 = string + " (" + n + ")";
        VtkObjectAdapter vtkObjectAdapter = new VtkObjectAdapter(object, 2, string2, this.getNextVtkObjectId());
        vtkObjectAdapter.setLocalTypeId(n);
        this.vtkObjectHashtable.put(vtkObjectAdapter.getId(), vtkObjectAdapter);
        this.mapperList.addVtkObject((VtkObject)vtkObjectAdapter);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObjectAdapter;
    }

    public synchronized VtkObject addDataSet(Object object, String string) {
        int n = this.sourceNumber++;
        String string2 = string + " (" + n + ")";
        VtkObjectAdapter vtkObjectAdapter = new VtkObjectAdapter(object, 3, string2, this.getNextVtkObjectId());
        vtkObjectAdapter.setLocalTypeId(n);
        this.vtkObjectHashtable.put(vtkObjectAdapter.getId(), vtkObjectAdapter);
        this.datasetList.addVtkObject((VtkObject)vtkObjectAdapter);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObjectAdapter;
    }

    public synchronized VtkObject addFilter(Filter filter, String string) {
        int n = this.filterNumber++;
        String string2 = string + " (" + n + ")";
        VtkObjectAdapter vtkObjectAdapter = new VtkObjectAdapter(filter, 4, string2, this.getNextVtkObjectId());
        vtkObjectAdapter.setLocalTypeId(n);
        this.vtkObjectHashtable.put(vtkObjectAdapter.getId(), vtkObjectAdapter);
        this.filterList.addVtkObject((VtkObject)vtkObjectAdapter);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObjectAdapter;
    }

    public synchronized VtkObject addLookupTable(vtkLookupTable vtkLookupTable2, String string) {
        int n = this.lookupNumber++;
        String string2 = string + " (" + n + ")";
        VtkObjectAdapter vtkObjectAdapter = new VtkObjectAdapter(vtkLookupTable2, 5, string2, this.getNextVtkObjectId());
        vtkObjectAdapter.setLocalTypeId(n);
        this.vtkObjectHashtable.put(vtkObjectAdapter.getId(), vtkObjectAdapter);
        this.lookupTableList.addVtkObject((VtkObject)vtkObjectAdapter);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObjectAdapter;
    }

    public synchronized VtkObject addScalarBar(vtkScalarBarActor vtkScalarBarActor2, String string) {
        int n = this.scalarBarNumber++;
        String string2 = string + " (" + n + ")";
        VtkObjectAdapter vtkObjectAdapter = new VtkObjectAdapter(vtkScalarBarActor2, 6, string2, this.getNextVtkObjectId());
        vtkObjectAdapter.setLocalTypeId(n);
        this.vtkObjectHashtable.put(vtkObjectAdapter.getId(), vtkObjectAdapter);
        this.scalarBarList.addVtkObject((VtkObject)vtkObjectAdapter);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObjectAdapter;
    }

    public synchronized VtkObject addTxtActor(vtkTextActor vtkTextActor2, String string) {
        int n = this.txtActorNumber++;
        String string2 = string + " (" + n + ")";
        VtkObjectAdapter vtkObjectAdapter = new VtkObjectAdapter(vtkTextActor2, 7, string2, this.getNextVtkObjectId());
        vtkObjectAdapter.setLocalTypeId(n);
        this.vtkObjectHashtable.put(vtkObjectAdapter.getId(), vtkObjectAdapter);
        this.txtActorList.addVtkObject((VtkObject)vtkObjectAdapter);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObjectAdapter;
    }

    public synchronized void removeVtkObject(Integer n) {
        VtkObject vtkObject = (VtkObject)this.vtkObjectHashtable.remove(n);
        if (vtkObject != null) {
            switch (vtkObject.getType()) {
                case 1: {
                    this.setActorVisible(vtkObject, false);
                    this.actorList.removeVtkObject(vtkObject);
                    break;
                }
                case 2: {
                    this.mapperList.removeVtkObject(vtkObject);
                    break;
                }
                case 3: {
                    this.datasetList.removeVtkObject(vtkObject);
                    break;
                }
                case 4: {
                    this.filterList.removeVtkObject(vtkObject);
                    break;
                }
                case 5: {
                    this.lookupTableList.removeVtkObject(vtkObject);
                    break;
                }
                case 6: {
                    this.setActorVisible(vtkObject, false);
                    this.scalarBarList.removeVtkObject(vtkObject);
                    break;
                }
                case 7: {
                    this.setActorVisible(vtkObject, false);
                    this.txtActorList.removeVtkObject(vtkObject);
                }
            }
            this.setChanged();
            this.notifyObservers(this.vtkObjectHashtable);
        }
    }

    public synchronized void removeVtkObject(VtkObject vtkObject) {
        this.removeVtkObject(vtkObject.getId());
    }

    public CassandraView getCassandraView() {
        return this.view;
    }

    public void setAxisVisible(boolean bl) {
        this.axes.setVisible(bl);
    }

    public void validateViewAndGo() {
        this.getCassandraView().validateViewAndGo();
    }

    public void validateViewAndWait() {
        this.getCassandraView().validateViewAndWait();
    }

    public void deepValidateView() {
        this.getCassandraView().deepValidateView();
    }

    public synchronized void addConnectivityListener(ConnectivityListener connectivityListener) {
        this.connectivityListener.add(connectivityListener);
    }

    public void notifyConnectivityChange(VtkObject vtkObject) {
        Iterator iterator = this.connectivityListener.iterator();
        while (iterator.hasNext()) {
            ((ConnectivityListener)iterator.next()).connectivityChange(vtkObject);
        }
    }

    public synchronized void removeConnectivityListener(ConnectivityListener connectivityListener) {
        this.connectivityListener.remove(connectivityListener);
    }
}

