/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.action;

import com.artenum.cassandra.PreferenceListener;
import com.artenum.cassandra.action.ExitAction;
import com.artenum.cassandra.launcher.DynamicClassLoader;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.ui.CassandraGUI;
import com.artenum.cassandra.ui.CassandraHelp;
import com.artenum.cassandra.util.CassandraToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class CassandraActionListener
implements ActionListener,
PreferenceListener {
    public static final String LOAD_PLUGIN = "LOAD_PLUGIN";
    public static final String OPEN_VTK_FILE = "OPEN_VTK_FILE";
    public static final String SAVE_VTK_FILE = "SAVE_VTK_FILE";
    public static final String IMPORT_DATA_FILE = "IMPORT_DATA_FILE";
    public static final String EXPORT_DATA_FILE = "EXPORT_DATA_FILE";
    public static final String SAVE_VTK_VIEW = "SAVE_VTK_VIEW";
    public static final String EXIT = "EXIT";
    public static final String ABOUT_CASSANDRA = "ABOUT_CASSANDRA";
    public static final String VIEW_RENDERER = "RENDERER";
    public static final String VIEW_CONSOLE = "CONSOLE";
    public static final String VIEW_PIPELINE = "PIPELINE";
    public static final String SET_BG_COLOR = "SET_BG_COLOR";
    public static final String SET_AMBIANT_LIGHT = "SET_AMBIANT_LIGHT";
    public static final String VIEW_AXIS = "AXIS";
    public static final String SET_TITLE = "SET_TITLE";
    public static final String SET_VIEW_XY = "SET_VIEW_XY";
    public static final String SET_VIEW_XZ = "SET_VIEW_XZ";
    public static final String SET_VIEW_YZ = "SET_VIEW_YZ";
    public static final String RESET_VIEW = "RESET_VIEW";
    public static final String PREF_PLUGIN_OPEN_DIR = "cassandra.pref.plugin.dir";
    public static final String PREF_VTK_FILE_OPEN_DIR = "cassandra.pref.vtk.file.dir";
    public static final String PREF_IMAGE_SAVE_DIR = "cassandra.pref.image.save.dir";
    private PipeLineManager pipeLineManager;
    private CassandraGUI view;
    private PluginManager pluginManager;
    private Component parentComponent;
    private DynamicPluginMenu dynamicPluginMenu;
    private ArrayList pluginClassNameList;
    private JDialog about;
    private ExitAction exitAction;
    private Hashtable prefTable;
    private File pluginDir;
    private File openVtkFileDir;
    private File imageSaveDir;

    public CassandraActionListener(CassandraGUI cassandraGUI, PipeLineManager pipeLineManager, PluginManager pluginManager) {
        this.pipeLineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.view = cassandraGUI;
        this.pluginClassNameList = new ArrayList();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(LOAD_PLUGIN)) {
            JFileChooser jFileChooser = new JFileChooser();
            if (this.pluginDir != null) {
                jFileChooser.setCurrentDirectory(this.pluginDir);
            }
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".jar");
                }

                public String getDescription() {
                    return "Jar files";
                }
            });
            if (jFileChooser.showOpenDialog(this.parentComponent) == 0) {
                File[] fileArray = jFileChooser.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (!fileArray[i].isFile()) continue;
                    DynamicClassLoader.getInstance().addJar(fileArray[i]);
                }
                this.reloadPlugings();
            }
        } else if (string.equals(SET_VIEW_XY)) {
            this.pipeLineManager.getCassandraView().setXYView();
            this.pipeLineManager.validateViewAndGo();
        } else if (string.equals(SET_VIEW_XZ)) {
            this.pipeLineManager.getCassandraView().setXZView();
            this.pipeLineManager.validateViewAndGo();
        } else if (string.equals(SET_VIEW_YZ)) {
            this.pipeLineManager.getCassandraView().setYZView();
            this.pipeLineManager.validateViewAndGo();
        } else if (string.equals(RESET_VIEW)) {
            this.pipeLineManager.getCassandraView().resetCamera();
            this.pipeLineManager.validateViewAndGo();
        } else if (string.equals(EXIT)) {
            if (this.exitAction == null) {
                System.exit(0);
            } else {
                this.exitAction.exit();
            }
        } else if (string.equals(OPEN_VTK_FILE)) {
            JFileChooser jFileChooser = new JFileChooser();
            if (this.openVtkFileDir != null) {
                jFileChooser.setCurrentDirectory(this.openVtkFileDir);
            }
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".vtk");
                }

                public String getDescription() {
                    return "Vtk files";
                }
            });
            if (jFileChooser.showOpenDialog(this.view) == 0) {
                File[] fileArray = jFileChooser.getSelectedFiles();
                CassandraToolBox.sortFileList(fileArray);
                for (int i = 0; i < fileArray.length; ++i) {
                    this.pipeLineManager.addVtkFile(fileArray[i]);
                }
            }
            this.pipeLineManager.validateViewAndGo();
        } else if (string.equals(VIEW_CONSOLE)) {
            if (((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()) {
                this.view.showConsole();
            } else {
                this.view.hideConsole();
            }
            this.pipeLineManager.deepValidateView();
        } else if (string.equals(SET_BG_COLOR)) {
            Color color = JColorChooser.showDialog(this.view, "Background color", Color.BLACK);
            if (color != null) {
                this.pipeLineManager.getCassandraView().setBackground(color);
            }
            this.pipeLineManager.validateViewAndGo();
        } else if (string.equals(SET_AMBIANT_LIGHT)) {
            Color color = JColorChooser.showDialog(this.view, "Ambiant light", Color.BLACK);
            if (color != null) {
                this.pipeLineManager.getCassandraView().setAmbiantLight(color);
            }
            this.pipeLineManager.validateViewAndGo();
        } else if (!string.equals(SET_TITLE)) {
            if (string.equals(VIEW_AXIS)) {
                this.pipeLineManager.setAxisVisible(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                this.pipeLineManager.validateViewAndGo();
            } else if (string.equals(VIEW_PIPELINE)) {
                if (((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()) {
                    this.view.showPipeLine();
                } else {
                    this.view.hidePipeLine();
                }
                this.pipeLineManager.deepValidateView();
            } else if (string.equals(SAVE_VTK_VIEW)) {
                JFileChooser jFileChooser = new JFileChooser();
                if (this.imageSaveDir != null) {
                    jFileChooser.setCurrentDirectory(this.imageSaveDir);
                }
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        return file.isFile() && (file.getName().toLowerCase().endsWith(".tif") || file.getName().toLowerCase().endsWith(".tiff"));
                    }

                    public String getDescription() {
                        return "Tiff image file";
                    }
                });
                jFileChooser.showSaveDialog(this.view);
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    String string2 = file.getAbsolutePath();
                    if (!string2.toLowerCase().endsWith(".tif") && !string2.toLowerCase().endsWith(".tiff")) {
                        string2 = string2 + ".tiff";
                    }
                    this.pipeLineManager.getCassandraView().HardCopy(string2, 1);
                }
            } else if (string.equals(VIEW_RENDERER)) {
                if (((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()) {
                    this.view.showRenderer();
                } else {
                    this.view.hideRenderer();
                }
                this.pipeLineManager.deepValidateView();
            } else if (string.equals(ABOUT_CASSANDRA)) {
                if (this.about == null) {
                    this.about = new CassandraHelp(this.view);
                }
                this.about.setLocationRelativeTo(null);
                this.about.setVisible(true);
            } else {
                System.out.println(string);
            }
        }
    }

    public void reloadPlugings() {
        Iterator iterator = DynamicClassLoader.getInstance().getPluginIntegratorList().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.pluginClassNameList.contains(string)) continue;
            this.pluginClassNameList.add(string);
            try {
                ((CassandraPluginIntegrator)DynamicClassLoader.getInstance().getPluginIntegrator(string)).integratePluginsInFramework(this.pipeLineManager, this.pluginManager, this.dynamicPluginMenu);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setDynamicPluginMenu(DynamicPluginMenu dynamicPluginMenu) {
        this.dynamicPluginMenu = dynamicPluginMenu;
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public void setExitAction(ExitAction exitAction) {
        this.exitAction = exitAction;
    }

    public void setPreferences(Hashtable hashtable) {
        this.prefTable = hashtable;
    }

    public void preferenceChanged() {
        if (this.prefTable != null) {
            this.imageSaveDir = (File)this.prefTable.get(PREF_IMAGE_SAVE_DIR);
            this.pluginDir = (File)this.prefTable.get(PREF_PLUGIN_OPEN_DIR);
            this.openVtkFileDir = (File)this.prefTable.get(PREF_VTK_FILE_OPEN_DIR);
        }
    }
}

