/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin;

import com.artenum.cassandra.plugin.CassandraPlugin;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class PluginManager
extends AbstractListModel
implements ListCellRenderer {
    private ArrayList pluginList = new ArrayList();
    private JLabel renderer = new JLabel();
    private Color selectedColor;
    private Color defaultColor;

    public PluginManager() {
        this.renderer.setOpaque(true);
        this.selectedColor = new Color(100, 100, 200);
        this.defaultColor = Color.white;
    }

    public int getSize() {
        return this.pluginList.size();
    }

    public Object getElementAt(int n) {
        return this.pluginList.get(n);
    }

    public void addPlugin(CassandraPlugin cassandraPlugin) {
        this.pluginList.add(cassandraPlugin);
        this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
    }

    public void removePlugin(CassandraPlugin cassandraPlugin) {
        int n = this.pluginList.indexOf(cassandraPlugin);
        if (n != -1) {
            this.pluginList.remove(n);
        }
        this.fireIntervalRemoved(this, n, n);
    }

    public CassandraPlugin getPlugin(int n) {
        return (CassandraPlugin)this.pluginList.get(n);
    }

    public CassandraPlugin getLastPlugin() {
        return this.getPlugin(this.getSize() - 1);
    }

    public Collection getData() {
        return this.pluginList;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.renderer.setBackground(bl ? this.selectedColor : this.defaultColor);
        this.renderer.setText(object.toString() + " (" + n + ")");
        return this.renderer;
    }
}

