/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.pipeline.CassandraTreeModel;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.ui.PluginPopupMenuManager;
import com.artenum.cassandra.ui.VtkObjectPopupMenuDipatcher;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class CassandraTree
extends JTree {
    private CassandraTreeModel treeModel;
    private VtkObjectPopupMenuDipatcher vtkPopupMenu;
    private PluginPopupMenuManager pluginPopupMenu;

    public CassandraTree(PipeLineManager pipeLineManager, PluginManager pluginManager) {
        this.treeModel = new CassandraTreeModel(pipeLineManager, pluginManager);
        this.vtkPopupMenu = new VtkObjectPopupMenuDipatcher(pipeLineManager, pluginManager);
        this.pluginPopupMenu = new PluginPopupMenuManager();
        this.addMouseListener(new PopupListener());
        this.setModel(this.treeModel);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (CassandraTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) == null) {
                    return;
                }
                Object object = ((DefaultMutableTreeNode)CassandraTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()).getLastPathComponent()).getUserObject();
                if (object instanceof VtkObject) {
                    CassandraTree.this.vtkPopupMenu.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), (VtkObject)object);
                }
                if (object instanceof CassandraPlugin) {
                    CassandraTree.this.pluginPopupMenu.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), (CassandraPlugin)object);
                }
            }
        }
    }
}

