/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkScalarsToColors;

public class MapperPopupMenu
extends JPopupMenu
implements ActionListener,
VtkObjectPopupMenu {
    public static final String MAPPER_SCALAR_VISIBILITY = "mapper.scalar.visibility";
    public static final String MAPPER_REMOVE = "mapper.remove";
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private VtkObject currentVtkObject;
    private JCheckBoxMenuItem viewScalarData;
    private JCheckBoxMenuItem chooseLookupTable;
    private RenameVtkObject mapperRename;
    private JMenuItem mapperRemove;
    private JMenu lookupTableList;

    public MapperPopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        this.viewScalarData = new JCheckBoxMenuItem("View scalar data");
        this.viewScalarData.setActionCommand(MAPPER_SCALAR_VISIBILITY);
        this.viewScalarData.addActionListener(this);
        this.add(this.viewScalarData);
        this.lookupTableList = new JMenu("Link to lookup table...");
        this.add(this.lookupTableList);
        this.mapperRename = new RenameVtkObject("Rename", "Rename mapper", null);
        this.add(this.mapperRename);
        this.addSeparator();
        this.mapperRemove = new JMenuItem("Remove");
        this.mapperRemove.setActionCommand(MAPPER_REMOVE);
        this.mapperRemove.addActionListener(this);
        this.add(this.mapperRemove);
    }

    private void updateLookupTableList() {
        VtkObject vtkObject = null;
        this.lookupTableList.removeAll();
        JMenuItem jMenuItem = null;
        Iterator iterator = this.pipeLineManager.getLookupTableList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            jMenuItem = new JMenuItem(vtkObject.getName());
            jMenuItem.addActionListener(new LookupTableSetter((vtkLookupTable)vtkObject.getVtkObject()));
            this.lookupTableList.add(jMenuItem);
        }
    }

    public void setCurrentVtkOject(VtkObject vtkObject) {
        this.currentVtkObject = vtkObject;
        this.mapperRename.setVtkObject(vtkObject);
        this.updateLookupTableList();
        this.viewScalarData.setSelected(((vtkMapper)vtkObject.getVtkObject()).GetScalarVisibility() == 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(MAPPER_SCALAR_VISIBILITY)) {
            ((vtkMapper)this.currentVtkObject.getVtkObject()).SetScalarVisibility((((vtkMapper)this.currentVtkObject.getVtkObject()).GetScalarVisibility() + 1) % 2);
            this.pipeLineManager.validateViewAndGo();
        } else if (string.equals(MAPPER_REMOVE)) {
            this.cascadeRemoveManager.removeMapper(this.currentVtkObject);
        }
    }

    private class LookupTableSetter
    implements ActionListener {
        private vtkLookupTable lookupTable;

        public LookupTableSetter(vtkLookupTable vtkLookupTable2) {
            this.lookupTable = vtkLookupTable2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((vtkMapper)MapperPopupMenu.this.currentVtkObject.getVtkObject()).SetLookupTable((vtkScalarsToColors)this.lookupTable);
            MapperPopupMenu.this.pipeLineManager.notifyConnectivityChange(MapperPopupMenu.this.currentVtkObject);
            MapperPopupMenu.this.pipeLineManager.validateViewAndGo();
        }
    }
}

