/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.util.FileComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JPopupMenu;
import vtk.vtkIVExporter;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkOBJExporter;
import vtk.vtkOOGLExporter;
import vtk.vtkRIBExporter;
import vtk.vtkRenderWindow;
import vtk.vtkVRMLExporter;

public class CassandraToolBox {
    public static Frame getParentFrame(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof Frame)) {
            if (component2 instanceof JPopupMenu) {
                component2 = ((JPopupMenu)component2).getInvoker();
                continue;
            }
            component2 = component2.getParent();
        }
        return (Frame)component2;
    }

    public static Dialog getParentDialog(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof Dialog)) {
            if (component2 instanceof JPopupMenu) {
                component2 = ((JPopupMenu)component2).getInvoker();
                continue;
            }
            component2 = component2.getParent();
        }
        return (Dialog)component2;
    }

    public static void updateMapper(PipeLineManager pipeLineManager, vtkLookupTable vtkLookupTable2) {
        Iterator iterator = pipeLineManager.getMapperList().getData().iterator();
        while (iterator.hasNext()) {
            vtkMapper vtkMapper2 = (vtkMapper)((VtkObject)iterator.next()).getVtkObject();
            if (!vtkMapper2.GetLookupTable().equals(vtkLookupTable2)) continue;
            vtkMapper2.SetScalarRange(vtkLookupTable2.GetTableRange());
        }
    }

    public static void updateLookupTableRange(vtkLookupTable vtkLookupTable2, double d, double d2) {
        double d3 = vtkLookupTable2.GetTableRange()[0];
        double d4 = vtkLookupTable2.GetTableRange()[1];
        if (d3 > d) {
            d3 = d;
        }
        if (d4 < d2) {
            d4 = d2;
        }
        vtkLookupTable2.SetRange(d3, d4);
        vtkLookupTable2.Build();
    }

    public static Color vtkColorConverter(double d, double d2, double d3) {
        return new Color((float)d, (float)d2, (float)d3);
    }

    public static double[] vtkColorConverter(Color color) {
        double[] dArray = new double[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        return dArray;
    }

    public static Color vtkColorConverter(double[] dArray) {
        return CassandraToolBox.vtkColorConverter(dArray[0], dArray[1], dArray[2]);
    }

    public static ArrayList splitNumbers(String string) {
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        int n = 1;
        int n2 = 2;
        int n3 = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') {
                if (n3 == n2 || n3 == -1) {
                    n3 = n;
                    stringBuffer = new StringBuffer();
                    arrayList.add(stringBuffer);
                }
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (n3 == n || n3 == -1) {
                n3 = n2;
                stringBuffer2 = new StringBuffer();
                arrayList.add(stringBuffer2);
            }
            stringBuffer2.append(string.charAt(i));
        }
        return arrayList;
    }

    public static void sortFileList(File[] fileArray) {
        Arrays.sort(fileArray, new FileComparator());
    }

    public static void saveObject(Object object, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
    }

    public static Object loadObject(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        return objectInputStream.readObject();
    }

    public static void export3DScene(String string, vtkRenderWindow vtkRenderWindow2) throws Exception {
        long l = System.currentTimeMillis();
        vtkIVExporter vtkIVExporter2 = new vtkIVExporter();
        vtkIVExporter2.SetInput(vtkRenderWindow2);
        vtkIVExporter2.SetFileName(string + ".oiv");
        vtkIVExporter2.Update();
        System.out.println("OpenInventor: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        vtkOOGLExporter vtkOOGLExporter2 = new vtkOOGLExporter();
        vtkOOGLExporter2.SetInput(vtkRenderWindow2);
        vtkOOGLExporter2.SetFileName(string + ".geom");
        vtkOOGLExporter2.Update();
        System.out.println("OOGL: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        vtkOBJExporter vtkOBJExporter2 = new vtkOBJExporter();
        vtkOBJExporter2.SetInput(vtkRenderWindow2);
        vtkOBJExporter2.SetFilePrefix(string);
        vtkOBJExporter2.Update();
        System.out.println("OBJ: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        vtkRIBExporter vtkRIBExporter2 = new vtkRIBExporter();
        vtkRIBExporter2.SetInput(vtkRenderWindow2);
        vtkRIBExporter2.SetFilePrefix(string);
        vtkRIBExporter2.Update();
        System.out.println("RIB: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        vtkVRMLExporter vtkVRMLExporter2 = new vtkVRMLExporter();
        vtkVRMLExporter2.SetInput(vtkRenderWindow2);
        vtkVRMLExporter2.SetFileName(string + ".wrl");
        vtkVRMLExporter2.Update();
        System.out.println("VRML: " + (System.currentTimeMillis() - l));
    }

    public static void export3DScene(vtkRenderWindow vtkRenderWindow2) throws Exception {
        long l = System.currentTimeMillis();
        byte[] byArray = new byte[0x100000];
        int n = -1;
        l = System.currentTimeMillis();
        vtkVRMLExporter vtkVRMLExporter2 = new vtkVRMLExporter();
        vtkVRMLExporter2.SetInput(vtkRenderWindow2);
        vtkVRMLExporter2.SetFileName("tmp.wrl");
        vtkVRMLExporter2.Update();
        FileInputStream fileInputStream = new FileInputStream("scene.wrl");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        FileOutputStream fileOutputStream = new FileOutputStream("scene.zip");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
        ZipEntry zipEntry = new ZipEntry("scene3D.wrl");
        zipOutputStream.putNextEntry(zipEntry);
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        fileInputStream.close();
        System.out.println("VRML: " + (System.currentTimeMillis() - l));
    }
}

