/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.threshold;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.threshold.ThresholdControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;
import vtk.vtkThreshold;

public class ThresholdPlugin
implements CassandraPlugin,
RemoveListener {
    public static final int THRESHOLD_BETWEEN = 1;
    public static final int THRESHOLD_LOWER = 2;
    public static final int THRESHOLD_UPPER = 3;
    private String name = "Threshold";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private ThresholdControlUI controlUI;
    private int nbUpdate = 0;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkThreshold threshold;
    private vtkDataSetMapper thresholdVtkMapper;
    private vtkActor thresholdVtkActor;
    private VtkObject actor;
    private VtkObject mapper;
    private VtkObject dataset;
    private VtkObject filter;
    private Filter filerImpl = new FilterImpl();

    public ThresholdPlugin() {
    }

    public ThresholdPlugin(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame frame) {
        this();
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.controlUI = new ThresholdControlUI(pipeLineManager, this, frame);
        this.contextualMenu = new JPopupMenu("Threshold menu");
        JMenuItem jMenuItem = new JMenuItem("Show control");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThresholdPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(jMenuItem);
        this.contextualMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThresholdPlugin.this.remove();
            }
        });
        this.contextualMenu.add(jMenuItem2);
        this.threshold = new vtkThreshold();
        this.thresholdVtkMapper = new vtkDataSetMapper();
        this.thresholdVtkMapper.SetInput((vtkDataSet)this.threshold.GetOutput());
        this.thresholdVtkActor = new vtkActor();
        this.thresholdVtkActor.SetMapper((vtkMapper)this.thresholdVtkMapper);
        this.lookupTable = new vtkLookupTable();
        this.lookupTable.SetHueRange(0.66667, 0.0);
        this.lookupTable.Build();
        this.thresholdVtkMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        vtkScalarBarActor vtkScalarBarActor2 = new vtkScalarBarActor();
        vtkScalarBarActor2.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        this.filerImpl.getOutputDataSet().add(this.threshold.GetOutput());
        this.filerImpl.addRemoveListener((RemoveListener)this);
        this.actor = pipeLineManager.addActor((Object)this.thresholdVtkActor, "Threshold");
        this.mapper = pipeLineManager.addMapper((Object)this.thresholdVtkMapper, "Threshold");
        this.dataset = pipeLineManager.addDataSet((Object)this.threshold.GetOutput(), "Threshold");
        this.filter = pipeLineManager.addFilter(this.filerImpl, "Threshold");
        pipeLineManager.addLookupTable(this.lookupTable, "Threshold");
        pipeLineManager.setActorVisible(pipeLineManager.addScalarBar(vtkScalarBarActor2, "Threshold"), true);
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.actor.setValide(false);
    }

    public void updateThreshold(vtkDataSet vtkDataSet2, int n, double d, double d2) {
        if (vtkDataSet2 != null) {
            this.threshold.SetInput(vtkDataSet2);
            switch (n) {
                case 1: {
                    this.threshold.ThresholdBetween(d, d2);
                    break;
                }
                case 2: {
                    this.threshold.ThresholdByLower(d2);
                    break;
                }
                case 3: {
                    this.threshold.ThresholdByUpper(d);
                }
            }
            this.filerImpl.getInputDataSet().clear();
            this.filerImpl.getInputDataSet().add(vtkDataSet2);
            if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.actor)) {
                this.actor.setValide(true);
                this.pipelineManager.setActorVisible(this.actor, true);
            } else {
                this.pipelineManager.setActorVisible(this.actor, false);
            }
            if ((this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.thresholdVtkMapper.GetLookupTable().equals(this.lookupTable)) {
                this.thresholdVtkMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
                this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
                this.lastDataSet = vtkDataSet2;
            }
            this.threshold.Update();
            this.threshold.GetOutput().UpdateData();
            this.pipelineManager.notifyConnectivityChange(this.filter);
        }
    }

    public String getName() {
        return this.name;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public String toString() {
        return this.getName();
    }

    public VtkObject getOutputDataSet() {
        return this.dataset;
    }
}

