/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.PipeLineManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import vtk.vtkVRMLImporter;

public class ImportFromVRML
implements ActionListener {
    private PipeLineManager pipelineManager;
    private Frame owner;
    private vtkVRMLImporter importer;

    public ImportFromVRML(PipeLineManager pipelineManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.owner = owner;
        this.importer = new vtkVRMLImporter();
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".wml");
            }

            public String getDescription() {
                return "WML files";
            }
        });
        if (chooser.showOpenDialog(this.owner) == 0) {
            String file = chooser.getSelectedFile().getAbsolutePath();
            try {
                this.importer.SetFileName(file);
                this.importer.SetRenderWindow(this.pipelineManager.getCassandraView().GetRenderWindow());
                this.importer.Update();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.owner, "Unable to load: " + file);
            }
        }
    }
}

