/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.graph.listener;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class SizeListener
implements MouseMotionListener,
MouseListener {
    private JComponent ui;
    private Component componentToListen;
    private int x;
    private int y;
    private int originalWidth;
    private int originalHeight;
    private int width;
    private int height;
    private Stroke stroke;
    private boolean resizing = false;
    private Dimension minimumSize;
    private Color bg = Color.WHITE;
    private Color fg = Color.BLACK;

    public SizeListener(JComponent jComponent, Component component, Stroke stroke, Dimension dimension) {
        this.ui = jComponent;
        this.componentToListen = component;
        this.minimumSize = dimension;
        component.addMouseMotionListener(this);
        component.addMouseListener(this);
        this.stroke = stroke;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.resizing) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            this.originalWidth = this.ui.getWidth();
            this.originalHeight = this.ui.getHeight();
            this.width = this.originalWidth;
            this.height = this.originalHeight;
            this.drawRect(this.fg, this.bg);
        }
        this.resizing = true;
        this.drawRect(this.fg, this.bg);
        this.width = Math.max(this.originalWidth + mouseEvent.getX() - this.x, (int)this.minimumSize.getWidth());
        this.height = Math.max(this.originalHeight + mouseEvent.getY() - this.y, (int)this.minimumSize.getHeight());
        this.drawRect(this.bg, this.fg);
    }

    private void drawRect(Color color, Color color2) {
        Graphics2D graphics2D = (Graphics2D)this.ui.getParent().getGraphics();
        graphics2D.setColor(color);
        graphics2D.setXORMode(color2);
        graphics2D.setStroke(this.stroke);
        graphics2D.drawRect((int)this.ui.getBounds().getLocation().getX(), (int)this.ui.getBounds().getLocation().getY(), this.width, this.height);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.resizing = false;
        this.ui.setSize(this.width, this.height);
        this.ui.doLayout();
        this.ui.validate();
        this.ui.getParent().repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }
}

