/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Spacer;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.VerticalAlignment;

public class AreaChartDemo
extends ApplicationFrame {
    public AreaChartDemo(String string) {
        super(string);
        double[][] dArrayArray = new double[][]{{1.0, 4.0, 3.0, 5.0, 5.0, 7.0, 7.0, 8.0}, {5.0, 7.0, 6.0, 8.0, 4.0, 4.0, 2.0, 1.0}, {4.0, 3.0, 2.0, 3.0, 6.0, 3.0, 4.0, 3.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Series ", "Type ", (double[][])dArrayArray);
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setEnforceFileExtensions(false);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createAreaChart("Area Chart", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        StandardLegend standardLegend = (StandardLegend)jFreeChart.getLegend();
        standardLegend.setAnchor(3);
        jFreeChart.setBackgroundPaint(Color.white);
        TextTitle textTitle = new TextTitle("An area chart demonstration.  We use this subtitle  as an example of what happens when you get a really long title or subtitle.");
        textTitle.setFont(new Font("SansSerif", 0, 12));
        textTitle.setPosition(RectangleEdge.TOP);
        textTitle.setSpacer(new Spacer(0, 0.05, 0.05, 0.05, 0.05));
        textTitle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        jFreeChart.addSubtitle(textTitle);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setForegroundAlpha(0.5f);
        categoryPlot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setDomainGridlinePaint(Color.white);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint(Color.white);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        categoryAxis.setLowerMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setLabelAngle(0.0);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        AreaChartDemo areaChartDemo = new AreaChartDemo("Area Chart Demo");
        areaChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)areaChartDemo));
        areaChartDemo.setVisible(true);
    }
}

