/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.chart.renderer.ItemLabelPosition;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class BarChartDemo3
extends ApplicationFrame {
    public BarChartDemo3(String string) {
        super(string);
        double[][] dArrayArray = new double[][]{{4.0, 3.0, -2.0, 3.0, 6.0, 3.0, 4.0, 3.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Series ", "Category ", (double[][])dArrayArray);
        JFreeChart jFreeChart = ChartFactory.createBarChart("Bar Chart Demo 3", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, false, true, false);
        jFreeChart.setBackgroundPaint(Color.lightGray);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setNoDataMessage("NO DATA!");
        CustomRenderer customRenderer = new CustomRenderer(new Paint[]{Color.red, Color.blue, Color.green, Color.yellow, Color.orange, Color.cyan, Color.magenta, Color.blue});
        customRenderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        customRenderer.setItemLabelsVisible(true);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 45.0);
        customRenderer.setPositiveItemLabelPosition(itemLabelPosition);
        categoryPlot.setRenderer(customRenderer);
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        valueAxis.setLowerMargin(0.15);
        valueAxis.setUpperMargin(0.15);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        BarChartDemo3 barChartDemo3 = new BarChartDemo3("Bar Chart Demo 3");
        barChartDemo3.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)barChartDemo3));
        barChartDemo3.setVisible(true);
    }

    class CustomRenderer
    extends BarRenderer {
        private Paint[] colors;

        public CustomRenderer(Paint[] paintArray) {
            this.colors = paintArray;
        }

        public Paint getItemPaint(int n, int n2) {
            return this.colors[n2 % this.colors.length];
        }
    }
}

