/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.demo.SampleXYZDataset;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.XYZDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BubblePlotDemo
extends ApplicationFrame {
    public BubblePlotDemo(String string) {
        super(string);
        SampleXYZDataset sampleXYZDataset = new SampleXYZDataset();
        JFreeChart jFreeChart = this.createChart(sampleXYZDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setVerticalZoom(true);
        chartPanel.setHorizontalZoom(true);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYZDataset xYZDataset) {
        JFreeChart jFreeChart = ChartFactory.createBubbleChart("Bubble Plot Demo", "X", "Y", xYZDataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setForegroundAlpha(0.65f);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setLowerMargin(0.15);
        numberAxis.setUpperMargin(0.15);
        NumberAxis numberAxis2 = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis2.setLowerMargin(0.15);
        numberAxis2.setUpperMargin(0.15);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        BubblePlotDemo bubblePlotDemo = new BubblePlotDemo("Bubble Plot Demo");
        bubblePlotDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)bubblePlotDemo));
        bubblePlotDemo.setVisible(true);
    }
}

