/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.StackedBarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class ExtendedStackedBarRenderer
extends StackedBarRenderer {
    private boolean showPositiveTotal = true;
    private boolean showNegativeTotal = true;
    private Font totalLabelFont = new Font("SansSerif", 0, 10);

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        EntityCollection entityCollection;
        double d;
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d2;
        double d3;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d4 = number.doubleValue();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d5 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number2 = categoryDataset.getValue(i, n2);
            if (number2 == null) continue;
            d3 = number2.doubleValue();
            if (d3 > 0.0) {
                d6 += d3;
                continue;
            }
            d7 += d3;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        if (d4 > 0.0) {
            d2 = valueAxis.translateValueToJava2D(d6, rectangle2D, rectangleEdge);
            d3 = valueAxis.translateValueToJava2D(d6 + d4, rectangle2D, rectangleEdge);
        } else {
            d2 = valueAxis.translateValueToJava2D(d7, rectangle2D, rectangleEdge);
            d3 = valueAxis.translateValueToJava2D(d7 + d4, rectangle2D, rectangleEdge);
        }
        double d8 = Math.min(d2, d3);
        double d9 = Math.max(Math.abs(d3 - d2), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d8, d5, d9, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d5, d8, categoryItemRendererState.getBarWidth(), d9);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_);
        }
        if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d4 < 0.0);
        }
        if (d4 > 0.0) {
            if (this.showPositiveTotal && this.isLastPositiveItem(categoryDataset, n, n2)) {
                graphics2D.setPaint(Color.black);
                graphics2D.setFont(this.totalLabelFont);
                d = this.calculateSumOfPositiveValuesForCategory(categoryDataset, n2);
                RefineryUtilities.drawRotatedString((String)String.valueOf(d), (Graphics2D)graphics2D, (float)((float)double_.getCenterX()), (float)((float)(double_.getMinY() - 4.0)), (TextAnchor)TextAnchor.BOTTOM_CENTER, (TextAnchor)TextAnchor.BOTTOM_CENTER, (double)0.0);
            }
        } else if (this.showNegativeTotal && this.isLastNegativeItem(categoryDataset, n, n2)) {
            graphics2D.setPaint(Color.black);
            graphics2D.setFont(this.totalLabelFont);
            d = this.calculateSumOfNegativeValuesForCategory(categoryDataset, n2);
            RefineryUtilities.drawRotatedString((String)String.valueOf(d), (Graphics2D)graphics2D, (float)((float)double_.getCenterX()), (float)((float)(double_.getMaxY() + 4.0)), (TextAnchor)TextAnchor.TOP_CENTER, (TextAnchor)TextAnchor.TOP_CENTER, (double)0.0);
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
            String string = null;
            if (categoryItemLabelGenerator != null) {
                string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            entityCollection.addEntity(categoryItemEntity);
        }
    }

    private boolean isLastPositiveItem(CategoryDataset categoryDataset, int n, int n2) {
        boolean bl = true;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return false;
        }
        for (int i = n + 1; i < categoryDataset.getRowCount(); ++i) {
            number = categoryDataset.getValue(i, n2);
            if (number == null) continue;
            bl = bl && number.doubleValue() <= 0.0;
        }
        return bl;
    }

    private boolean isLastNegativeItem(CategoryDataset categoryDataset, int n, int n2) {
        boolean bl = true;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return false;
        }
        for (int i = n + 1; i < categoryDataset.getRowCount(); ++i) {
            number = categoryDataset.getValue(i, n2);
            if (number == null) continue;
            bl = bl && number.doubleValue() >= 0.0;
        }
        return bl;
    }

    private double calculateSumOfPositiveValuesForCategory(CategoryDataset categoryDataset, int n) {
        double d = 0.0;
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            double d2;
            Number number = categoryDataset.getValue(i, n);
            if (number == null || !((d2 = number.doubleValue()) > 0.0)) continue;
            d += d2;
        }
        return d;
    }

    private double calculateSumOfNegativeValuesForCategory(CategoryDataset categoryDataset, int n) {
        double d = 0.0;
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            double d2;
            Number number = categoryDataset.getValue(i, n);
            if (number == null || !((d2 = number.doubleValue()) < 0.0)) continue;
            d += d2;
        }
        return d;
    }
}

