/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.HighLowDataset;
import org.jfree.data.MovingAverage;
import org.jfree.data.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HighLowChartDemo2
extends ApplicationFrame {
    public HighLowChartDemo2(String string) {
        super(string);
        HighLowDataset highLowDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(highLowDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private HighLowDataset createDataset() {
        return DemoDatasetFactory.createHighLowDataset();
    }

    private JFreeChart createChart(HighLowDataset highLowDataset) {
        JFreeChart jFreeChart = ChartFactory.createHighLowChart("OHLC Demo 2", "Time", "Value", highLowDataset, true);
        DateAxis dateAxis = (DateAxis)jFreeChart.getXYPlot().getDomainAxis();
        dateAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        XYDataset xYDataset = MovingAverage.createMovingAverage((XYDataset)highLowDataset, "-MAVG", 259200000L, 0L);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setSecondaryDataset(0, xYDataset);
        xYPlot.setSecondaryRenderer(0, new StandardXYItemRenderer());
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        HighLowChartDemo2 highLowChartDemo2 = new HighLowChartDemo2("OHLC Demo 2");
        highLowChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)highLowChartDemo2));
        highLowChartDemo2.setVisible(true);
    }
}

