/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.Spacer;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.demo.EmptyXYDataset;
import org.jfree.chart.demo.SampleXYDataset;
import org.jfree.chart.demo.SampleXYDataset2;
import org.jfree.chart.demo.SampleXYDatasetThread;
import org.jfree.chart.labels.HighLowToolTipGenerator;
import org.jfree.chart.labels.TimeSeriesToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.HighLowRenderer;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.CategoryDataset;
import org.jfree.data.CombinedDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultValueDataset;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.MovingAverage;
import org.jfree.data.PieDataset;
import org.jfree.data.SeriesDataset;
import org.jfree.data.SignalsDataset;
import org.jfree.data.SubSeriesDataset;
import org.jfree.data.WindDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public class JFreeChartDemoBase {
    public static final String[][] CHART_COMMANDS = new String[][]{{"HORIZONTAL_BAR_CHART", "createHorizontalBarChart", "chart1"}, {"HORIZONTAL_STACKED_BAR_CHART", "createStackedHorizontalBarChart", "chart2"}, {"VERTICAL_BAR_CHART", "createVerticalBarChart", "chart3"}, {"VERTICAL_3D_BAR_CHART", "createVertical3DBarChart", "chart4"}, {"VERTICAL_STACKED_BAR_CHART", "createVerticalStackedBarChart", "chart5"}, {"VERTICAL_STACKED_3D_BAR_CHART", "createVerticalStacked3DBarChart", "chart6"}, {"PIE_CHART_1", "createPieChartOne", "chart7"}, {"PIE_CHART_2", "createPieChartTwo", "chart8"}, {"XY_PLOT", "createXYPlot", "chart9"}, {"TIME_SERIES_1_CHART", "createTimeSeries1Chart", "chart10"}, {"TIME_SERIES_2_CHART", "createTimeSeries2Chart", "chart11"}, {"TIME_SERIES_WITH_MA_CHART", "createTimeSeriesWithMAChart", "chart12"}, {"HIGH_LOW_CHART", "createHighLowChart", "chart13"}, {"CANDLESTICK_CHART", "createCandlestickChart", "chart14"}, {"SIGNAL_CHART", "createSignalChart", "chart15"}, {"WIND_PLOT", "createWindPlot", "chart16"}, {"SCATTER_PLOT", "createScatterPlot", "chart17"}, {"LINE_CHART", "createLineChart", "chart18"}, {"VERTICAL_XY_BAR_CHART", "createVerticalXYBarChart", "chart19"}, {"XY_PLOT_NULL", "createNullXYPlot", "chart20"}, {"XY_PLOT_ZERO", "createXYPlotZeroData", "chart21"}, {"TIME_SERIES_CHART_SCROLL", "createTimeSeriesChartInScrollPane", "chart22"}, {"SINGLE_SERIES_BAR_CHART", "createSingleSeriesBarChart", "chart23"}, {"DYNAMIC_CHART", "createDynamicXYChart", "chart24"}, {"OVERLAID_CHART", "createOverlaidChart", "chart25"}, {"HORIZONTALLY_COMBINED_CHART", "createHorizontallyCombinedChart", "chart26"}, {"VERTICALLY_COMBINED_CHART", "createVerticallyCombinedChart", "chart27"}, {"COMBINED_OVERLAID_CHART", "createCombinedAndOverlaidChart1", "chart28"}, {"COMBINED_OVERLAID_DYNAMIC_CHART", "createCombinedAndOverlaidDynamicXYChart", "chart29"}, {"THERMOMETER_CHART", "createThermometerChart", "chart30"}, {"METER_CHART", "createMeterChartCircle", "chart31"}, {"GANTT_CHART", "createGanttChart", "chart32"}, {"METER_CHART2", "createMeterChartPie", "chart33"}, {"METER_CHART3", "createMeterChartChord", "chart34"}, {"COMPASS_CHART", "createCompassChart", "chart35"}};
    public static final String BASE_RESOURCE_CLASS = "org.jfree.chart.demo.resources.DemoResources";
    private ResourceBundle resources;
    private JFreeChart[] charts = new JFreeChart[CHART_COMMANDS.length];

    public JFreeChartDemoBase() {
        this.resources = ResourceBundle.getBundle(BASE_RESOURCE_CLASS);
    }

    public JFreeChart getChart(int n) {
        if (n < 0 && n >= this.charts.length) {
            n = 0;
        }
        if (this.charts[n] == null) {
            try {
                Method method = this.getClass().getDeclaredMethod(CHART_COMMANDS[n][1], null);
                this.charts[n] = (JFreeChart)method.invoke((Object)this, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.charts[n];
    }

    public ResourceBundle getResources() {
        return this.resources;
    }

    public JFreeChart createHorizontalBarChart() {
        String string = this.resources.getString("bar.horizontal.title");
        String string2 = this.resources.getString("bar.horizontal.domain");
        String string3 = this.resources.getString("bar.horizontal.range");
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createBarChart(string, string2, string3, categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        jFreeChart.getLegend().setAnchor(2);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.orange));
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setRangeCrosshairVisible(false);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setInverted(true);
        return jFreeChart;
    }

    public JFreeChart createStackedHorizontalBarChart() {
        String string = this.resources.getString("bar.horizontal-stacked.title");
        String string2 = this.resources.getString("bar.horizontal-stacked.domain");
        String string3 = this.resources.getString("bar.horizontal-stacked.range");
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(string, string2, string3, categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createVerticalBarChart() {
        String string = this.resources.getString("bar.vertical.title");
        String string2 = this.resources.getString("bar.vertical.domain");
        String string3 = this.resources.getString("bar.vertical.range");
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createBarChart(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setForegroundAlpha(0.9f);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public JFreeChart createVertical3DBarChart() {
        String string = this.resources.getString("bar.vertical3D.title");
        String string2 = this.resources.getString("bar.vertical3D.domain");
        String string3 = this.resources.getString("bar.vertical3D.range");
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createBarChart3D(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setForegroundAlpha(0.75f);
        return jFreeChart;
    }

    public JFreeChart createVerticalStackedBarChart() {
        String string = this.resources.getString("bar.vertical-stacked.title");
        String string2 = this.resources.getString("bar.vertical-stacked.domain");
        String string3 = this.resources.getString("bar.vertical-stacked.range");
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return jFreeChart;
    }

    public JFreeChart createVerticalStacked3DBarChart() {
        String string = this.resources.getString("bar.vertical-stacked3D.title");
        String string2 = this.resources.getString("bar.vertical-stacked3D.domain");
        String string3 = this.resources.getString("bar.vertical-stacked3D.range");
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return jFreeChart;
    }

    public JFreeChart createPieChartOne() {
        String string = this.resources.getString("pie.pie1.title");
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        PieDataset pieDataset = DatasetUtilities.createPieDatasetForRow(categoryDataset, 0);
        JFreeChart jFreeChart = ChartFactory.createPieChart(string, pieDataset, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.orange));
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setCircular(false);
        piePlot.setRadius(0.6);
        piePlot.setExplodePercent(1, 1.0);
        return jFreeChart;
    }

    public JFreeChart createPieChartTwo() {
        String string = this.resources.getString("pie.pie2.title");
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        Comparable comparable = (Comparable)categoryDataset.getColumnKeys().get(1);
        PieDataset pieDataset = DatasetUtilities.createPieDatasetForColumn(categoryDataset, comparable);
        JFreeChart jFreeChart = ChartFactory.createPieChart(string, pieDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.lightGray);
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setSectionLabelType(5);
        piePlot.setBackgroundImage(JFreeChart.INFO.getLogo());
        piePlot.setBackgroundPaint(Color.white);
        piePlot.setBackgroundAlpha(0.6f);
        piePlot.setForegroundAlpha(0.75f);
        return jFreeChart;
    }

    public JFreeChart createXYPlot() {
        String string = this.resources.getString("xyplot.sample1.title");
        String string2 = this.resources.getString("xyplot.sample1.domain");
        String string3 = this.resources.getString("xyplot.sample1.range");
        XYDataset xYDataset = DemoDatasetFactory.createSampleXYDataset();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        return jFreeChart;
    }

    public JFreeChart createTimeSeries1Chart() {
        String string = this.resources.getString("timeseries.sample1.title");
        String string2 = this.resources.getString("timeseries.sample1.subtitle");
        String string3 = this.resources.getString("timeseries.sample1.domain");
        String string4 = this.resources.getString("timeseries.sample1.range");
        String string5 = this.resources.getString("timeseries.sample1.copyright");
        TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection3();
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart(string, string3, string4, timeSeriesCollection, true, true, false);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 0, 12));
        textTitle.setSpacer(new Spacer(0, 0.05, 0.05, 0.05, 0.0));
        jFreeChart.addSubtitle(textTitle);
        TextTitle textTitle2 = new TextTitle(string5, new Font("SansSerif", 0, 9));
        textTitle2.setPosition(RectangleEdge.BOTTOM);
        textTitle2.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        jFreeChart.addSubtitle(textTitle2);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        XYPlot xYPlot = jFreeChart.getXYPlot();
        DateAxis dateAxis = (DateAxis)xYPlot.getDomainAxis();
        dateAxis.setVerticalTickLabels(true);
        return jFreeChart;
    }

    public JFreeChart createTimeSeries2Chart() {
        String string = this.resources.getString("timeseries.sample2.title");
        String string2 = this.resources.getString("timeseries.sample2.subtitle");
        String string3 = this.resources.getString("timeseries.sample2.domain");
        String string4 = this.resources.getString("timeseries.sample2.range");
        TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection4();
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart(string, string3, string4, timeSeriesCollection, true, true, false);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        XYPlot xYPlot = jFreeChart.getXYPlot();
        LogarithmicAxis logarithmicAxis = new LogarithmicAxis(string4);
        xYPlot.setRangeAxis(logarithmicAxis);
        return jFreeChart;
    }

    public JFreeChart createTimeSeriesWithMAChart() {
        String string = this.resources.getString("timeseries.sample3.title");
        String string2 = this.resources.getString("timeseries.sample3.domain");
        String string3 = this.resources.getString("timeseries.sample3.range");
        String string4 = this.resources.getString("timeseries.sample3.subtitle");
        TimeSeries timeSeries = DemoDatasetFactory.createJPYTimeSeries();
        TimeSeries timeSeries2 = MovingAverage.createMovingAverage(timeSeries, "30 Day Moving Average", 30, 30);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        timeSeriesCollection.addSeries(timeSeries2);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart(string, string2, string3, timeSeriesCollection, true, true, false);
        TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createHighLowChart() {
        String string = this.resources.getString("timeseries.highlow.title");
        String string2 = this.resources.getString("timeseries.highlow.domain");
        String string3 = this.resources.getString("timeseries.highlow.range");
        String string4 = this.resources.getString("timeseries.highlow.subtitle");
        HighLowDataset highLowDataset = DemoDatasetFactory.createHighLowDataset();
        JFreeChart jFreeChart = ChartFactory.createHighLowChart(string, string2, string3, highLowDataset, true);
        TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.magenta));
        return jFreeChart;
    }

    public JFreeChart createCandlestickChart() {
        String string = this.resources.getString("timeseries.candlestick.title");
        String string2 = this.resources.getString("timeseries.candlestick.domain");
        String string3 = this.resources.getString("timeseries.candlestick.range");
        String string4 = this.resources.getString("timeseries.candlestick.subtitle");
        HighLowDataset highLowDataset = DemoDatasetFactory.createHighLowDataset();
        JFreeChart jFreeChart = ChartFactory.createCandlestickChart(string, string2, string3, highLowDataset, false);
        TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        return jFreeChart;
    }

    public JFreeChart createSignalChart() {
        String string = this.resources.getString("timeseries.signal.title");
        String string2 = this.resources.getString("timeseries.signal.domain");
        String string3 = this.resources.getString("timeseries.signal.range");
        String string4 = this.resources.getString("timeseries.signal.subtitle");
        SignalsDataset signalsDataset = DemoDatasetFactory.createSampleSignalDataset();
        JFreeChart jFreeChart = ChartFactory.createSignalChart(string, string2, string3, signalsDataset, true);
        TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createThermometerChart() {
        String string = this.resources.getString("meter.thermo.title");
        String string2 = this.resources.getString("meter.thermo.subtitle");
        String string3 = this.resources.getString("meter.thermo.units");
        DefaultValueDataset defaultValueDataset = new DefaultValueDataset(new Double(34.0));
        ThermometerPlot thermometerPlot = new ThermometerPlot(defaultValueDataset);
        thermometerPlot.setUnits(string3);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, thermometerPlot, false);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createMeterChartCircle() {
        String string = this.resources.getString("meter.meter.title");
        String string2 = this.resources.getString("meter.meter.subtitle");
        DefaultValueDataset defaultValueDataset = new DefaultValueDataset(50.0);
        MeterPlot meterPlot = new MeterPlot(defaultValueDataset);
        meterPlot.setMeterAngle(270);
        meterPlot.setDialShape(DialShape.CIRCLE);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, meterPlot, false);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createMeterChartPie() {
        String string = this.resources.getString("meter.meter.title");
        String string2 = this.resources.getString("meter.meter.subtitle");
        DefaultValueDataset defaultValueDataset = new DefaultValueDataset(50.0);
        MeterPlot meterPlot = new MeterPlot(defaultValueDataset);
        meterPlot.setMeterAngle(270);
        meterPlot.setDialShape(DialShape.PIE);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, meterPlot, false);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createMeterChartChord() {
        String string = this.resources.getString("meter.meter.title");
        String string2 = this.resources.getString("meter.meter.subtitle");
        DefaultValueDataset defaultValueDataset = new DefaultValueDataset(45.0);
        MeterPlot meterPlot = new MeterPlot(defaultValueDataset);
        meterPlot.setMeterAngle(270);
        meterPlot.setDialShape(DialShape.CHORD);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, meterPlot, false);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createCompassChart() {
        String string = this.resources.getString("meter.compass.title");
        String string2 = this.resources.getString("meter.compass.subtitle");
        DefaultValueDataset defaultValueDataset = new DefaultValueDataset(new Double(45.0));
        CompassPlot compassPlot = new CompassPlot(defaultValueDataset);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, compassPlot, false);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createWindPlot() {
        String string = this.resources.getString("other.wind.title");
        String string2 = this.resources.getString("other.wind.domain");
        String string3 = this.resources.getString("other.wind.range");
        WindDataset windDataset = DemoDatasetFactory.createWindDataset1();
        JFreeChart jFreeChart = ChartFactory.createWindPlot(string, string2, string3, windDataset, true, false, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        return jFreeChart;
    }

    public JFreeChart createScatterPlot() {
        String string = this.resources.getString("other.scatter.title");
        String string2 = this.resources.getString("other.scatter.domain");
        String string3 = this.resources.getString("other.scatter.range");
        SampleXYDataset2 sampleXYDataset2 = new SampleXYDataset2();
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(string, string2, string3, sampleXYDataset2, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairVisible(true);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        return jFreeChart;
    }

    public JFreeChart createLineChart() {
        String string = this.resources.getString("other.line.title");
        String string2 = this.resources.getString("other.line.domain");
        String string3 = this.resources.getString("other.line.range");
        CategoryDataset categoryDataset = DemoDatasetFactory.createCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createLineChart(string, string2, string3, categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundImage(JFreeChart.INFO.getLogo());
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.green));
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundAlpha(0.65f);
        return jFreeChart;
    }

    public JFreeChart createVerticalXYBarChart() {
        String string = this.resources.getString("other.xybar.title");
        String string2 = this.resources.getString("other.xybar.domain");
        String string3 = this.resources.getString("other.xybar.range");
        TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection1();
        timeSeriesCollection.setDomainIsPointsInTime(false);
        JFreeChart jFreeChart = ChartFactory.createXYBarChart(string, string2, string3, timeSeriesCollection, PlotOrientation.VERTICAL, true, false, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        XYItemRenderer xYItemRenderer = jFreeChart.getXYPlot().getRenderer();
        xYItemRenderer.setToolTipGenerator(new TimeSeriesToolTipGenerator());
        return jFreeChart;
    }

    public JFreeChart createNullXYPlot() {
        String string = this.resources.getString("test.null.title");
        String string2 = this.resources.getString("test.null.domain");
        String string3 = this.resources.getString("test.null.range");
        XYDataset xYDataset = null;
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, xYDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return jFreeChart;
    }

    public JFreeChart createXYPlotZeroData() {
        String string = this.resources.getString("test.zero.title");
        String string2 = this.resources.getString("test.zero.domain");
        String string3 = this.resources.getString("test.zero.range");
        EmptyXYDataset emptyXYDataset = new EmptyXYDataset();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, emptyXYDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return jFreeChart;
    }

    public JFreeChart createTimeSeriesChartInScrollPane() {
        String string = this.resources.getString("test.scroll.title");
        String string2 = this.resources.getString("test.scroll.domain");
        String string3 = this.resources.getString("test.scroll.range");
        String string4 = this.resources.getString("test.scroll.subtitle");
        TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection2();
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart(string, string2, string3, timeSeriesCollection, true, true, false);
        TextTitle textTitle = new TextTitle(string4, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.gray));
        return jFreeChart;
    }

    public JFreeChart createSingleSeriesBarChart() {
        String string = this.resources.getString("test.single.title");
        String string2 = this.resources.getString("test.single.domain");
        String string3 = this.resources.getString("test.single.range");
        String string4 = this.resources.getString("test.single.subtitle1");
        String string5 = this.resources.getString("test.single.subtitle2");
        CategoryDataset categoryDataset = DemoDatasetFactory.createSingleSeriesCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createBarChart(string, string2, string3, categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        jFreeChart.addSubtitle(new TextTitle(string4));
        jFreeChart.addSubtitle(new TextTitle(string5));
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.red));
        return jFreeChart;
    }

    public JFreeChart createDynamicXYChart() {
        String string = this.resources.getString("test.dynamic.title");
        String string2 = this.resources.getString("test.dynamic.domain");
        String string3 = this.resources.getString("test.dynamic.range");
        SampleXYDataset sampleXYDataset = new SampleXYDataset();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, sampleXYDataset, PlotOrientation.VERTICAL, true, true, false);
        SampleXYDatasetThread sampleXYDatasetThread = new SampleXYDatasetThread(sampleXYDataset);
        Thread thread = new Thread(sampleXYDatasetThread);
        thread.start();
        return jFreeChart;
    }

    public JFreeChart createOverlaidChart() {
        String string = this.resources.getString("combined.overlaid.title");
        String string2 = this.resources.getString("combined.overlaid.subtitle");
        String string3 = this.resources.getString("combined.overlaid.domain");
        String string4 = this.resources.getString("combined.overlaid.range");
        HighLowDataset highLowDataset = DemoDatasetFactory.createHighLowDataset();
        DateAxis dateAxis = new DateAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        numberAxis.setAutoRangeIncludesZero(false);
        HighLowRenderer highLowRenderer = new HighLowRenderer();
        highLowRenderer.setToolTipGenerator(new HighLowToolTipGenerator());
        XYPlot xYPlot = new XYPlot(highLowDataset, dateAxis, numberAxis, highLowRenderer);
        XYDataset xYDataset = MovingAverage.createMovingAverage((XYDataset)highLowDataset, " (Moving Average)", 432000000L, 432000000L);
        xYPlot.setSecondaryDataset(0, xYDataset);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        standardXYItemRenderer.setToolTipGenerator(new TimeSeriesToolTipGenerator("d-MMM-yyyy", "0.00"));
        xYPlot.setSecondaryRenderer(0, standardXYItemRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, true);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createHorizontallyCombinedChart() {
        String string = this.resources.getString("combined.horizontal.title");
        String string2 = this.resources.getString("combined.horizontal.subtitle");
        String[] stringArray = this.resources.getStringArray("combined.horizontal.domains");
        String string3 = this.resources.getString("combined.horizontal.range");
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeries timeSeries = DemoDatasetFactory.createEURTimeSeries();
        timeSeriesCollection.addSeries(timeSeries);
        TimeSeriesCollection timeSeriesCollection2 = new TimeSeriesCollection();
        TimeSeries timeSeries2 = MovingAverage.createMovingAverage(timeSeries, "EUR/GBP (30 Day MA)", 30, 30);
        timeSeriesCollection2.addSeries(timeSeries);
        timeSeriesCollection2.addSeries(timeSeries2);
        TimeSeriesCollection timeSeriesCollection3 = new TimeSeriesCollection();
        timeSeriesCollection3.addSeries(timeSeries);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        CombinedRangeXYPlot combinedRangeXYPlot = new CombinedRangeXYPlot(numberAxis);
        combinedRangeXYPlot.setRenderer(new StandardXYItemRenderer());
        int[] nArray = new int[]{1, 1, 1};
        XYPlot xYPlot = new XYPlot(timeSeriesCollection, new DateAxis(stringArray[0]), null, new StandardXYItemRenderer());
        combinedRangeXYPlot.add(xYPlot, nArray[0]);
        XYPlot xYPlot2 = new XYPlot(timeSeriesCollection2, new DateAxis(stringArray[1]), null, new StandardXYItemRenderer());
        combinedRangeXYPlot.add(xYPlot2, nArray[1]);
        XYPlot xYPlot3 = new XYPlot(timeSeriesCollection3, new DateAxis(stringArray[2]), null, new XYBarRenderer(0.2));
        combinedRangeXYPlot.add(xYPlot3, nArray[2]);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, combinedRangeXYPlot, true);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createVerticallyCombinedChart() {
        String string = this.resources.getString("combined.vertical.title");
        String string2 = this.resources.getString("combined.vertical.subtitle");
        String string3 = this.resources.getString("combined.vertical.domain");
        String[] stringArray = this.resources.getStringArray("combined.vertical.ranges");
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeries timeSeries = DemoDatasetFactory.createEURTimeSeries();
        timeSeriesCollection.addSeries(timeSeries);
        TimeSeriesCollection timeSeriesCollection2 = new TimeSeriesCollection();
        TimeSeries timeSeries2 = DemoDatasetFactory.createJPYTimeSeries();
        TimeSeries timeSeries3 = MovingAverage.createMovingAverage(timeSeries2, "JPY/GBP (30 Day MA)", 30, 30);
        timeSeriesCollection2.addSeries(timeSeries2);
        timeSeriesCollection2.addSeries(timeSeries3);
        HighLowDataset highLowDataset = DemoDatasetFactory.createHighLowDataset();
        TimeSeriesCollection timeSeriesCollection3 = new TimeSeriesCollection();
        timeSeriesCollection3.addSeries(timeSeries);
        DateAxis dateAxis = new DateAxis(string3);
        CombinedDomainXYPlot combinedDomainXYPlot = new CombinedDomainXYPlot(dateAxis);
        int[] nArray = new int[]{1, 1, 1, 1};
        XYPlot xYPlot = new XYPlot(timeSeriesCollection, null, new NumberAxis(stringArray[0]), new StandardXYItemRenderer());
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setTickLabelFont(new Font("Monospaced", 0, 7));
        numberAxis.setLabelFont(new Font("SansSerif", 0, 8));
        numberAxis.setAutoRangeIncludesZero(false);
        combinedDomainXYPlot.add(xYPlot, nArray[0]);
        XYPlot xYPlot2 = new XYPlot(timeSeriesCollection2, null, new NumberAxis(stringArray[1]), new StandardXYItemRenderer());
        NumberAxis numberAxis2 = (NumberAxis)xYPlot2.getRangeAxis();
        numberAxis2.setTickLabelFont(new Font("Monospaced", 0, 7));
        numberAxis2.setLabelFont(new Font("SansSerif", 0, 8));
        numberAxis2.setAutoRangeIncludesZero(false);
        combinedDomainXYPlot.add(xYPlot2, nArray[1]);
        XYPlot xYPlot3 = new XYPlot(highLowDataset, null, new NumberAxis(stringArray[2]), null);
        HighLowRenderer highLowRenderer = new HighLowRenderer();
        xYPlot3.setRenderer(highLowRenderer);
        NumberAxis numberAxis3 = (NumberAxis)xYPlot3.getRangeAxis();
        numberAxis3.setTickLabelFont(new Font("Monospaced", 0, 7));
        numberAxis3.setLabelFont(new Font("SansSerif", 0, 8));
        numberAxis3.setAutoRangeIncludesZero(false);
        combinedDomainXYPlot.add(xYPlot3, nArray[2]);
        XYPlot xYPlot4 = new XYPlot(timeSeriesCollection3, null, new NumberAxis(stringArray[3]), null);
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        xYPlot4.setRenderer(xYBarRenderer);
        NumberAxis numberAxis4 = (NumberAxis)xYPlot4.getRangeAxis();
        numberAxis4.setTickLabelFont(new Font("Monospaced", 0, 7));
        numberAxis4.setLabelFont(new Font("SansSerif", 0, 8));
        numberAxis4.setAutoRangeIncludesZero(false);
        combinedDomainXYPlot.add(xYPlot4, nArray[3]);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, combinedDomainXYPlot, true);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createCombinedAndOverlaidChart1() {
        String string = this.resources.getString("combined.combined-overlaid.title");
        String string2 = this.resources.getString("combined.combined-overlaid.subtitle");
        String string3 = this.resources.getString("combined.combined-overlaid.domain");
        String[] stringArray = this.resources.getStringArray("combined.combined-overlaid.ranges");
        TimeSeries timeSeries = DemoDatasetFactory.createJPYTimeSeries();
        TimeSeries timeSeries2 = MovingAverage.createMovingAverage(timeSeries, "30 Day Moving Average", 30, 30);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        TimeSeriesCollection timeSeriesCollection2 = new TimeSeriesCollection();
        timeSeriesCollection2.addSeries(timeSeries);
        timeSeriesCollection2.addSeries(timeSeries2);
        HighLowDataset highLowDataset = DemoDatasetFactory.createHighLowDataset();
        XYDataset xYDataset = MovingAverage.createMovingAverage((XYDataset)highLowDataset, " (MA)", 432000000L, 432000000L);
        NumberAxis[] numberAxisArray = new NumberAxis[3];
        for (int i = 0; i < numberAxisArray.length; ++i) {
            numberAxisArray[i] = new NumberAxis(stringArray[i]);
            if (i > 1) continue;
            numberAxisArray[i].setAutoRangeIncludesZero(false);
        }
        CombinedDomainXYPlot combinedDomainXYPlot = new CombinedDomainXYPlot(new DateAxis(string3));
        int[] nArray = new int[]{1, 2, 2};
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        XYPlot xYPlot = new XYPlot(timeSeriesCollection, null, new NumberAxis(stringArray[0]), standardXYItemRenderer);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setTickLabelFont(new Font("Monospaced", 0, 7));
        numberAxis.setLabelFont(new Font("SansSerif", 0, 8));
        numberAxis.setAutoRangeIncludesZero(false);
        combinedDomainXYPlot.add(xYPlot, nArray[0]);
        XYPlot xYPlot2 = new XYPlot(timeSeriesCollection, null, new NumberAxis(stringArray[1]), new StandardXYItemRenderer());
        NumberAxis numberAxis2 = (NumberAxis)xYPlot2.getRangeAxis();
        numberAxis2.setTickLabelFont(new Font("Monospaced", 0, 7));
        numberAxis2.setLabelFont(new Font("SansSerif", 0, 8));
        numberAxis2.setAutoRangeIncludesZero(false);
        xYPlot2.setSecondaryDataset(0, timeSeriesCollection2);
        xYPlot2.setSecondaryRenderer(0, new StandardXYItemRenderer());
        combinedDomainXYPlot.add(xYPlot2, nArray[1]);
        HighLowRenderer highLowRenderer = new HighLowRenderer();
        XYPlot xYPlot3 = new XYPlot(highLowDataset, null, new NumberAxis(stringArray[2]), highLowRenderer);
        NumberAxis numberAxis3 = (NumberAxis)xYPlot3.getRangeAxis();
        numberAxis3.setTickLabelFont(new Font("Monospaced", 0, 7));
        numberAxis3.setLabelFont(new Font("SansSerif", 0, 8));
        numberAxis3.setAutoRangeIncludesZero(false);
        xYPlot3.setSecondaryDataset(0, xYDataset);
        xYPlot3.setSecondaryRenderer(0, new StandardXYItemRenderer());
        combinedDomainXYPlot.add(xYPlot3, nArray[2]);
        JFreeChart jFreeChart = new JFreeChart(string, new Font("SansSerif", 1, 12), combinedDomainXYPlot, true);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 10));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        return jFreeChart;
    }

    public JFreeChart createCombinedAndOverlaidDynamicXYChart() {
        String string = this.resources.getString("combined.dynamic.title");
        String string2 = this.resources.getString("combined.dynamic.subtitle");
        String string3 = this.resources.getString("combined.dynamic.domain");
        String[] stringArray = this.resources.getStringArray("combined.dynamic.ranges");
        SampleXYDataset sampleXYDataset = new SampleXYDataset();
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)sampleXYDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)sampleXYDataset, 1);
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add(subSeriesDataset);
        combinedDataset.add(subSeriesDataset2);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setTickMarksVisible(true);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis[] numberAxisArray = new NumberAxis[4];
        for (int i = 0; i < numberAxisArray.length; ++i) {
            numberAxisArray[i] = new NumberAxis(stringArray[i]);
            numberAxisArray[i].setAutoRangeIncludesZero(false);
        }
        CombinedDomainXYPlot combinedDomainXYPlot = new CombinedDomainXYPlot(numberAxis);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        XYPlot xYPlot = new XYPlot(subSeriesDataset, null, numberAxisArray[0], standardXYItemRenderer);
        combinedDomainXYPlot.add(xYPlot, 1);
        StandardXYItemRenderer standardXYItemRenderer2 = new StandardXYItemRenderer();
        XYPlot xYPlot2 = new XYPlot(subSeriesDataset2, null, numberAxisArray[1], standardXYItemRenderer2);
        combinedDomainXYPlot.add(xYPlot2, 1);
        XYPlot xYPlot3 = new XYPlot(subSeriesDataset, null, numberAxisArray[2], new StandardXYItemRenderer());
        xYPlot3.setSecondaryDataset(0, subSeriesDataset2);
        xYPlot3.setSecondaryRenderer(0, new StandardXYItemRenderer());
        combinedDomainXYPlot.add(xYPlot3, 1);
        StandardXYItemRenderer standardXYItemRenderer3 = new StandardXYItemRenderer();
        XYPlot xYPlot4 = new XYPlot(sampleXYDataset, null, numberAxisArray[3], standardXYItemRenderer3);
        combinedDomainXYPlot.add(xYPlot4, 1);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, combinedDomainXYPlot, true);
        TextTitle textTitle = new TextTitle(string2, new Font("SansSerif", 1, 12));
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.cyan));
        SampleXYDatasetThread sampleXYDatasetThread = new SampleXYDatasetThread(sampleXYDataset);
        Thread thread = new Thread(sampleXYDatasetThread);
        thread.start();
        return jFreeChart;
    }

    public JFreeChart createGanttChart() {
        String string = this.resources.getString("gantt.task.title");
        String string2 = this.resources.getString("gantt.task.domain");
        String string3 = this.resources.getString("gantt.task.range");
        IntervalCategoryDataset intervalCategoryDataset = JFreeChartDemoBase.createGanttDataset1();
        JFreeChart jFreeChart = ChartFactory.createGanttChart(string, string2, string3, intervalCategoryDataset, true, true, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        return jFreeChart;
    }

    private static IntervalCategoryDataset createGanttDataset1() {
        TaskSeries taskSeries = new TaskSeries("Scheduled");
        taskSeries.add(new Task("Write Proposal", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 3, 2001), JFreeChartDemoBase.date(5, 3, 2001))));
        taskSeries.add(new Task("Obtain Approval", new SimpleTimePeriod(JFreeChartDemoBase.date(9, 3, 2001), JFreeChartDemoBase.date(9, 3, 2001))));
        taskSeries.add(new Task("Requirements Analysis", new SimpleTimePeriod(JFreeChartDemoBase.date(10, 3, 2001), JFreeChartDemoBase.date(5, 4, 2001))));
        taskSeries.add(new Task("Design Phase", new SimpleTimePeriod(JFreeChartDemoBase.date(6, 4, 2001), JFreeChartDemoBase.date(30, 4, 2001))));
        taskSeries.add(new Task("Design Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(2, 5, 2001), JFreeChartDemoBase.date(2, 5, 2001))));
        taskSeries.add(new Task("Alpha Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(3, 5, 2001), JFreeChartDemoBase.date(31, 6, 2001))));
        taskSeries.add(new Task("Design Review", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 7, 2001), JFreeChartDemoBase.date(8, 7, 2001))));
        taskSeries.add(new Task("Revised Design Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(10, 7, 2001), JFreeChartDemoBase.date(10, 7, 2001))));
        taskSeries.add(new Task("Beta Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(12, 7, 2001), JFreeChartDemoBase.date(12, 8, 2001))));
        taskSeries.add(new Task("Testing", new SimpleTimePeriod(JFreeChartDemoBase.date(13, 8, 2001), JFreeChartDemoBase.date(31, 9, 2001))));
        taskSeries.add(new Task("Final Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 10, 2001), JFreeChartDemoBase.date(15, 10, 2001))));
        taskSeries.add(new Task("Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(28, 10, 2001), JFreeChartDemoBase.date(30, 10, 2001))));
        TaskSeries taskSeries2 = new TaskSeries("Actual");
        taskSeries2.add(new Task("Write Proposal", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 3, 2001), JFreeChartDemoBase.date(5, 3, 2001))));
        taskSeries2.add(new Task("Obtain Approval", new SimpleTimePeriod(JFreeChartDemoBase.date(9, 3, 2001), JFreeChartDemoBase.date(9, 3, 2001))));
        taskSeries2.add(new Task("Requirements Analysis", new SimpleTimePeriod(JFreeChartDemoBase.date(10, 3, 2001), JFreeChartDemoBase.date(15, 4, 2001))));
        taskSeries2.add(new Task("Design Phase", new SimpleTimePeriod(JFreeChartDemoBase.date(15, 4, 2001), JFreeChartDemoBase.date(17, 5, 2001))));
        taskSeries2.add(new Task("Design Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(30, 5, 2001), JFreeChartDemoBase.date(30, 5, 2001))));
        taskSeries2.add(new Task("Alpha Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(1, 6, 2001), JFreeChartDemoBase.date(12, 8, 2001))));
        taskSeries2.add(new Task("Design Review", new SimpleTimePeriod(JFreeChartDemoBase.date(12, 8, 2001), JFreeChartDemoBase.date(22, 8, 2001))));
        taskSeries2.add(new Task("Revised Design Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(25, 8, 2001), JFreeChartDemoBase.date(27, 8, 2001))));
        taskSeries2.add(new Task("Beta Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(27, 8, 2001), JFreeChartDemoBase.date(30, 9, 2001))));
        taskSeries2.add(new Task("Testing", new SimpleTimePeriod(JFreeChartDemoBase.date(31, 9, 2001), JFreeChartDemoBase.date(17, 10, 2001))));
        taskSeries2.add(new Task("Final Implementation", new SimpleTimePeriod(JFreeChartDemoBase.date(18, 10, 2001), JFreeChartDemoBase.date(5, 11, 2001))));
        taskSeries2.add(new Task("Signoff", new SimpleTimePeriod(JFreeChartDemoBase.date(10, 11, 2001), JFreeChartDemoBase.date(11, 11, 2001))));
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        taskSeriesCollection.add(taskSeries);
        taskSeriesCollection.add(taskSeries2);
        return taskSeriesCollection;
    }

    private static Date date(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n3, n2, n);
        Date date = calendar.getTime();
        return date;
    }
}

