/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.LayeredBarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class LayeredBarChartDemo2
extends ApplicationFrame {
    public LayeredBarChartDemo2(String string) {
        super(string);
        double[][] dArrayArray = new double[][]{{41.0, 33.0, 22.0, 64.0, 42.0, 62.0, 22.0, 14.0}, {55.0, 63.0, 55.0, 48.0, 54.0, 37.0, 41.0, 39.0}, {57.0, 75.0, 43.0, 33.0, 63.0, 46.0, 57.0, 33.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Series ", "Factor ", (double[][])dArrayArray);
        CategoryAxis categoryAxis = new CategoryAxis("Category");
        NumberAxis numberAxis = new NumberAxis("Score (%)");
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, new LayeredBarRenderer());
        categoryPlot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart jFreeChart = new JFreeChart("Layered Bar Chart Demo 2", JFreeChartConstants.DEFAULT_TITLE_FONT, categoryPlot, true);
        jFreeChart.setBackgroundPaint(Color.lightGray);
        LayeredBarRenderer layeredBarRenderer = (LayeredBarRenderer)categoryPlot.getRenderer();
        layeredBarRenderer.setSeriesBarWidth(0, 1.0);
        layeredBarRenderer.setSeriesBarWidth(1, 0.7);
        layeredBarRenderer.setSeriesBarWidth(2, 0.5);
        layeredBarRenderer.setItemMargin(0.01);
        CategoryAxis categoryAxis2 = categoryPlot.getDomainAxis();
        categoryAxis2.setCategoryMargin(0.25);
        categoryAxis2.setUpperMargin(0.05);
        categoryAxis2.setLowerMargin(0.05);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        LayeredBarChartDemo2 layeredBarChartDemo2 = new LayeredBarChartDemo2("Layered Bar Chart Demo 2");
        layeredBarChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)layeredBarChartDemo2));
        layeredBarChartDemo2.setVisible(true);
    }
}

