/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Marker;
import org.jfree.chart.MarkerLabelPosition;
import org.jfree.chart.annotations.XYDrawableAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.demo.CircleDrawer;
import org.jfree.chart.labels.TimeSeriesToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class MarkerDemo1
extends ApplicationFrame {
    static /* synthetic */ Class class$org$jfree$data$time$Minute;

    public MarkerDemo1(String string) {
        super(string);
        XYDataset xYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setVerticalZoom(true);
        chartPanel.setHorizontalZoom(true);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot("Marker Demo 1", "X", "Y", xYDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.getLegend().setAnchor(2);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.getRenderer().setToolTipGenerator(new TimeSeriesToolTipGenerator());
        DateAxis dateAxis = new DateAxis("Time");
        dateAxis.setUpperMargin(0.5);
        xYPlot.setDomainAxis(dateAxis);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        valueAxis.setUpperMargin(0.3);
        valueAxis.setLowerMargin(0.5);
        Marker marker = new Marker(200.0, Color.green);
        marker.setLabel("Bid Start Price");
        marker.setLabelPosition(MarkerLabelPosition.TOP_RIGHT);
        xYPlot.addRangeMarker(marker);
        Marker marker2 = new Marker(175.0, Color.red);
        marker2.setLabel("Target Price");
        marker2.setLabelPosition(MarkerLabelPosition.TOP_RIGHT);
        xYPlot.addRangeMarker(marker2);
        Hour hour = new Hour(2, new Day(22, 5, 2003));
        double d = hour.getFirstMillisecond();
        Marker marker3 = new Marker(d, Color.orange);
        marker3.setLabel("Original Close (02:00)");
        xYPlot.addDomainMarker(marker3);
        Minute minute = new Minute(15, hour);
        d = minute.getFirstMillisecond();
        Marker marker4 = new Marker(d, Color.red);
        marker4.setLabel("Close Date (02:15)");
        marker4.setLabelPosition(MarkerLabelPosition.TOP_RIGHT);
        xYPlot.addDomainMarker(marker4);
        Hour hour2 = new Hour(2, new Day(22, 5, 2003));
        Minute minute2 = new Minute(10, hour2);
        d = minute2.getFirstMillisecond();
        CircleDrawer circleDrawer = new CircleDrawer(Color.red, new BasicStroke(1.0f), null);
        XYDrawableAnnotation xYDrawableAnnotation = new XYDrawableAnnotation(d, 163.0, 11.0, 11.0, circleDrawer);
        xYPlot.addAnnotation(xYDrawableAnnotation);
        XYPointerAnnotation xYPointerAnnotation = new XYPointerAnnotation("Best Bid", d, 163.0, 2.356194490192345);
        xYPointerAnnotation.setBaseRadius(35.0);
        xYPointerAnnotation.setTipRadius(10.0);
        xYPointerAnnotation.setFont(new Font("SansSerif", 0, 9));
        xYPointerAnnotation.setPaint(Color.blue);
        xYPointerAnnotation.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
        xYPlot.addAnnotation(xYPointerAnnotation);
        return jFreeChart;
    }

    private XYDataset createDataset() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(this.createSupplier1Bids());
        timeSeriesCollection.addSeries(this.createSupplier2Bids());
        return timeSeriesCollection;
    }

    private TimeSeries createSupplier1Bids() {
        Hour hour = new Hour(1, new Day(22, 5, 2003));
        TimeSeries timeSeries = new TimeSeries("Supplier 1", class$org$jfree$data$time$Minute == null ? (class$org$jfree$data$time$Minute = MarkerDemo1.class$("org.jfree.data.time.Minute")) : class$org$jfree$data$time$Minute);
        timeSeries.add((RegularTimePeriod)new Minute(13, hour), 200.0);
        timeSeries.add((RegularTimePeriod)new Minute(14, hour), 195.0);
        timeSeries.add((RegularTimePeriod)new Minute(45, hour), 190.0);
        timeSeries.add((RegularTimePeriod)new Minute(46, hour), 188.0);
        timeSeries.add((RegularTimePeriod)new Minute(47, hour), 185.0);
        timeSeries.add((RegularTimePeriod)new Minute(52, hour), 180.0);
        return timeSeries;
    }

    private TimeSeries createSupplier2Bids() {
        Hour hour = new Hour(1, new Day(22, 5, 2003));
        Hour hour2 = (Hour)hour.next();
        TimeSeries timeSeries = new TimeSeries("Supplier 2", class$org$jfree$data$time$Minute == null ? (class$org$jfree$data$time$Minute = MarkerDemo1.class$("org.jfree.data.time.Minute")) : class$org$jfree$data$time$Minute);
        timeSeries.add((RegularTimePeriod)new Minute(25, hour), 185.0);
        timeSeries.add((RegularTimePeriod)new Minute(0, hour2), 175.0);
        timeSeries.add((RegularTimePeriod)new Minute(5, hour2), 170.0);
        timeSeries.add((RegularTimePeriod)new Minute(6, hour2), 168.0);
        timeSeries.add((RegularTimePeriod)new Minute(9, hour2), 165.0);
        timeSeries.add((RegularTimePeriod)new Minute(10, hour2), 163.0);
        return timeSeries;
    }

    public static void main(String[] stringArray) {
        MarkerDemo1 markerDemo1 = new MarkerDemo1("Marker Demo 1");
        markerDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)markerDemo1));
        markerDemo1.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

