/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URL;
import javax.swing.ImageIcon;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class MultiShapesXYDemo
extends ApplicationFrame {
    private static final int NUMBER_OF_POINTS = 200;
    private static final double INCREMENT = 0.1;
    private static final float R1 = 0.0f;
    private static final float G1 = 1.0f;
    private static final float B1 = 0.0f;
    private static final float R2 = 1.0f;
    private static final float G2 = 0.0f;
    private static final float B2 = 0.0f;
    private XYSeries series;
    private Image ballImage;
    private Image arrowImage;

    public MultiShapesXYDemo(String string) {
        super(string);
        System.out.println("About to get images...");
        URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/jfree/chart/demo/redball.png");
        URL uRL2 = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/jfree/chart/demo/arrow.png");
        if (uRL != null && uRL2 != null) {
            this.ballImage = new ImageIcon(uRL).getImage();
            this.arrowImage = new ImageIcon(uRL2).getImage();
            MediaTracker mediaTracker = new MediaTracker((Component)((Object)this));
            mediaTracker.addImage(this.ballImage, 0);
            mediaTracker.addImage(this.arrowImage, 1);
            try {
                mediaTracker.waitForID(0);
                mediaTracker.waitForID(1);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            System.out.println("Images loaded");
        } else {
            System.err.println("Can't find images");
        }
        System.out.println("Images done.");
        this.series = new XYSeries("Some Data");
        for (int i = 0; i < 200; ++i) {
            double d = 0.1 * (double)i;
            double d2 = Math.sin(d);
            this.series.add(d, d2);
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(this.series);
        NumberAxis numberAxis = new NumberAxis("x");
        NumberAxis numberAxis2 = new NumberAxis("sin(x)");
        DemoRenderer demoRenderer = new DemoRenderer();
        XYPlot xYPlot = new XYPlot(xYSeriesCollection, numberAxis, numberAxis2, demoRenderer);
        JFreeChart jFreeChart = new JFreeChart(xYPlot);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(600, 380));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        MultiShapesXYDemo multiShapesXYDemo = new MultiShapesXYDemo("XYPlot With Multiple Shapes");
        multiShapesXYDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)multiShapesXYDemo));
        multiShapesXYDemo.setVisible(true);
    }

    class DemoRenderer
    extends StandardXYItemRenderer {
        public DemoRenderer() {
            super(5, null);
        }

        protected boolean isShapeFilled(Plot plot, int n, int n2, double d, double d2) {
            return n2 % 2 == 0;
        }

        protected double getShapeScale(Plot plot, int n, int n2, double d, double d2) {
            float f = (float)n2 / 200.0f;
            return 6.0 - (double)f * 4.0;
        }

        protected Paint getPaint(Plot plot, int n, int n2, double d, double d2) {
            float f = (float)n2 / 200.0f;
            float f2 = (1.0f - f) * 0.0f + f * 1.0f;
            float f3 = (1.0f - f) * 1.0f + f * 0.0f;
            float f4 = (1.0f - f) * 0.0f + f * 0.0f;
            Color color = new Color(f2, f3, f4);
            return color;
        }

        protected Shape getShape(Plot plot, int n, int n2, double d, double d2, double d3) {
            RectangularShape rectangularShape;
            switch (n2 % 2) {
                case 0: {
                    rectangularShape = new Rectangle2D.Double(d - 0.5 * d3, d2 - 0.5 * d3, d3, d3);
                    break;
                }
                default: {
                    rectangularShape = new Ellipse2D.Double(d - 0.5 * d3, d2 - 0.5 * d3, d3, d3);
                }
            }
            return rectangularShape;
        }

        protected Image getImage(Plot plot, int n, int n2, double d, double d2) {
            if (n2 % 10 == 0) {
                return MultiShapesXYDemo.this.ballImage;
            }
            if (n2 == 42) {
                return MultiShapesXYDemo.this.arrowImage;
            }
            return null;
        }

        protected Point getImageHotspot(Plot plot, int n, int n2, double d, double d2, Image image) {
            if (image == MultiShapesXYDemo.this.arrowImage) {
                return new Point(0, image.getHeight(null));
            }
            return super.getImageHotspot(plot, n, n2, d, d2, image);
        }
    }
}

