/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class OverlaidBarChartDemo
extends ApplicationFrame {
    public OverlaidBarChartDemo(String string) {
        super(string);
        double[][] dArrayArray = new double[][]{{1.0, 4.0, 3.0, 5.0, 5.0, 7.0, 7.0, 8.0}, {5.0, 7.0, 6.0, 8.0, 4.0, 4.0, 2.0, 1.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("S", "Category ", (double[][])dArrayArray);
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator();
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setItemLabelGenerator(standardCategoryItemLabelGenerator);
        CategoryPlot categoryPlot = new CategoryPlot();
        categoryPlot.setDataset(categoryDataset);
        categoryPlot.setRenderer(barRenderer);
        categoryPlot.setDomainAxis(new CategoryAxis("Category"));
        categoryPlot.setRangeAxis(new NumberAxis("Value"));
        categoryPlot.setOrientation(PlotOrientation.VERTICAL);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setDomainGridlinesVisible(true);
        NumberAxis numberAxis = new NumberAxis("Axis 2");
        categoryPlot.setSecondaryRangeAxis(0, numberAxis);
        double[][] dArrayArray2 = new double[][]{{9.0, 7.0, 2.0, 6.0, 6.0, 9.0, 5.0, 4.0}};
        CategoryDataset categoryDataset2 = DatasetUtilities.createCategoryDataset("T", "Category", (double[][])dArrayArray2);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        categoryPlot.setSecondaryDataset(0, categoryDataset2);
        categoryPlot.setSecondaryRenderer(0, lineAndShapeRenderer);
        double[][] dArrayArray3 = new double[][]{{94.0, 75.0, 22.0, 74.0, 83.0, 9.0, 23.0, 98.0}};
        CategoryDataset categoryDataset3 = DatasetUtilities.createCategoryDataset("R", "Category", (double[][])dArrayArray3);
        categoryPlot.setSecondaryDataset(1, categoryDataset3);
        categoryPlot.setSecondaryRenderer(1, new LineAndShapeRenderer());
        categoryPlot.mapSecondaryDatasetToRangeAxis(1, new Integer(0));
        categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        JFreeChart jFreeChart = new JFreeChart(categoryPlot);
        jFreeChart.setTitle("Overlaid Bar Chart");
        jFreeChart.setLegend(new StandardLegend());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        OverlaidBarChartDemo overlaidBarChartDemo = new OverlaidBarChartDemo("Overlaid Bar Chart Demo");
        overlaidBarChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)overlaidBarChartDemo));
        overlaidBarChartDemo.setVisible(true);
    }
}

