/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.LevelRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class OverlaidBarChartDemo2
extends ApplicationFrame {
    public OverlaidBarChartDemo2(String string) {
        super(string);
        JFreeChart jFreeChart = this.createChart();
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart() {
        double[][] dArrayArray = new double[][]{{1.0, 4.0, 3.0, 5.0, 5.0}, {5.0, 7.0, 6.0, 8.0, 4.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("S", "Category ", (double[][])dArrayArray);
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator();
        BarRenderer barRenderer = new BarRenderer();
        barRenderer.setItemLabelGenerator(standardCategoryItemLabelGenerator);
        CategoryPlot categoryPlot = new CategoryPlot();
        categoryPlot.setDataset(categoryDataset);
        categoryPlot.setRenderer(barRenderer);
        categoryPlot.setDomainAxis(new CategoryAxis("Category"));
        categoryPlot.setRangeAxis(new NumberAxis("Value"));
        categoryPlot.setOrientation(PlotOrientation.VERTICAL);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setDomainGridlinesVisible(true);
        double[][] dArrayArray2 = new double[][]{{6.0, 7.0, 2.0, 6.0, 6.0}, {4.0, 2.0, 1.0, 3.0, 2.0}};
        CategoryDataset categoryDataset2 = DatasetUtilities.createCategoryDataset("Prior ", "Category", (double[][])dArrayArray2);
        LevelRenderer levelRenderer = new LevelRenderer();
        levelRenderer.setSeriesStroke(0, new BasicStroke(2.0f));
        levelRenderer.setSeriesStroke(1, new BasicStroke(2.0f));
        categoryPlot.setSecondaryDataset(0, categoryDataset2);
        categoryPlot.setSecondaryRenderer(0, levelRenderer);
        categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setRangeGridlinePaint(Color.white);
        JFreeChart jFreeChart = new JFreeChart(categoryPlot);
        jFreeChart.setTitle("Overlaid Bar Chart");
        jFreeChart.setLegend(new StandardLegend());
        jFreeChart.setBackgroundPaint(Color.white);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        OverlaidBarChartDemo2 overlaidBarChartDemo2 = new OverlaidBarChartDemo2("Overlaid Bar Chart Demo 2");
        overlaidBarChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)overlaidBarChartDemo2));
        overlaidBarChartDemo2.setVisible(true);
    }
}

