/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.text.DecimalFormat;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.renderer.IntervalBarRenderer;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultIntervalCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class OverlaidCategoryChartDemo
extends ApplicationFrame {
    private static Color[] barColors = null;
    private static Color[] dotColors = null;
    private static Color[] lineColors = null;
    private static Font labelFont = null;
    private static Font titleFont = null;
    private JFreeChart chart = null;

    public OverlaidCategoryChartDemo(String string) {
        super(string);
        DefaultIntervalCategoryDataset defaultIntervalCategoryDataset = null;
        double[][] dArrayArray = new double[][]{{-0.0315, 0.0159, 0.0306, 0.0453, 0.0557}};
        double[][] dArrayArray2 = new double[][]{{0.1931, 0.1457, 0.131, 0.1163, 0.1059}};
        defaultIntervalCategoryDataset = new DefaultIntervalCategoryDataset(dArrayArray, dArrayArray2);
        double[][] dArrayArray3 = new double[][]{{0.0808, 0.0808, 0.0808, 0.0808, 0.0808}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Series ", "Category ", (double[][])dArrayArray3);
        double[][] dArray = new double[4][5];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                dArray[i][j] = Math.random() * 0.56 - 0.18;
            }
        }
        CategoryDataset categoryDataset2 = DatasetUtilities.createCategoryDataset("Series ", "Category ", dArray);
        String string2 = "Strategie Sicherheit";
        String string3 = "Zeitraum (in Jahren)";
        String string4 = "Performance";
        CategoryAxis categoryAxis = new CategoryAxis(string3);
        categoryAxis.setLabelFont(titleFont);
        categoryAxis.setTickLabelFont(labelFont);
        categoryAxis.setTickMarksVisible(false);
        NumberAxis numberAxis = new NumberAxis(string4);
        numberAxis.setLabelFont(titleFont);
        numberAxis.setTickLabelFont(labelFont);
        numberAxis.setRange(-0.2, 0.4);
        DecimalFormat decimalFormat = new DecimalFormat("0.##%");
        numberAxis.setTickUnit(new NumberTickUnit(0.05, decimalFormat));
        IntervalBarRenderer intervalBarRenderer = new IntervalBarRenderer();
        intervalBarRenderer.setItemLabelsVisible(Boolean.TRUE);
        CategoryPlot categoryPlot = new CategoryPlot(defaultIntervalCategoryDataset, categoryAxis, numberAxis, intervalBarRenderer);
        categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setOutlinePaint(Color.black);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer(1);
        lineAndShapeRenderer.setItemLabelsVisible(Boolean.TRUE);
        categoryPlot.setSecondaryDataset(0, categoryDataset);
        categoryPlot.setSecondaryRenderer(0, lineAndShapeRenderer);
        LineAndShapeRenderer lineAndShapeRenderer2 = new LineAndShapeRenderer(3);
        categoryPlot.setSecondaryDataset(1, categoryDataset2);
        categoryPlot.setSecondaryRenderer(1, lineAndShapeRenderer2);
        this.chart = new JFreeChart(string2, titleFont, categoryPlot, false);
        this.chart.setBackgroundPaint(Color.white);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        OverlaidCategoryChartDemo overlaidCategoryChartDemo = new OverlaidCategoryChartDemo("Overlaid Category Chart Demo");
        overlaidCategoryChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)overlaidCategoryChartDemo));
        overlaidCategoryChartDemo.setVisible(true);
    }

    static {
        barColors = new Color[1];
        OverlaidCategoryChartDemo.barColors[0] = new Color(51, 102, 153);
        dotColors = new Color[1];
        OverlaidCategoryChartDemo.dotColors[0] = Color.white;
        lineColors = new Color[4];
        OverlaidCategoryChartDemo.lineColors[0] = Color.red;
        OverlaidCategoryChartDemo.lineColors[1] = Color.blue;
        OverlaidCategoryChartDemo.lineColors[2] = Color.yellow;
        OverlaidCategoryChartDemo.lineColors[3] = Color.magenta;
        labelFont = new Font("Helvetica", 0, 10);
        titleFont = new Font("Helvetica", 1, 14);
    }
}

