/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.TimeSeriesToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class OverlaidXYPlotDemo2
extends ApplicationFrame {
    static /* synthetic */ Class class$org$jfree$data$time$Day;

    public OverlaidXYPlotDemo2(String string) {
        super(string);
        JFreeChart jFreeChart = this.createOverlaidChart();
        ChartPanel chartPanel = new ChartPanel(jFreeChart, true, true, true, true, true);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createOverlaidChart() {
        DateAxis dateAxis = new DateAxis("Date");
        dateAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        NumberAxis numberAxis = new NumberAxis("Value");
        IntervalXYDataset intervalXYDataset = this.createDataset1();
        XYBarRenderer xYBarRenderer = new XYBarRenderer(0.2);
        xYBarRenderer.setToolTipGenerator(new TimeSeriesToolTipGenerator("d-MMM-yyyy", "0.00"));
        XYPlot xYPlot = new XYPlot(intervalXYDataset, dateAxis, numberAxis, xYBarRenderer);
        double d = new Day(9, 3, 2002).getMiddleMillisecond();
        XYTextAnnotation xYTextAnnotation = new XYTextAnnotation("Hello!", d, 10000.0);
        xYTextAnnotation.setFont(new Font("SansSerif", 0, 9));
        xYPlot.addAnnotation(xYTextAnnotation);
        NumberAxis numberAxis2 = new NumberAxis("Value 2");
        xYPlot.setSecondaryRangeAxis(0, numberAxis2);
        XYDataset xYDataset = this.createDataset2A();
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        standardXYItemRenderer.setToolTipGenerator(new TimeSeriesToolTipGenerator("d-MMM-yyyy", "0.00"));
        xYPlot.setSecondaryDataset(0, xYDataset);
        xYPlot.setSecondaryRenderer(0, standardXYItemRenderer);
        XYDataset xYDataset2 = this.createDataset2B();
        xYPlot.setSecondaryDataset(1, xYDataset2);
        xYPlot.setSecondaryRenderer(1, new StandardXYItemRenderer());
        xYPlot.mapSecondaryDatasetToRangeAxis(1, new Integer(0));
        xYPlot.setOrientation(PlotOrientation.VERTICAL);
        return new JFreeChart("Overlaid Plot Example", JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, true);
    }

    private IntervalXYDataset createDataset1() {
        TimeSeries timeSeries = new TimeSeries("Series 1", class$org$jfree$data$time$Day == null ? (class$org$jfree$data$time$Day = OverlaidXYPlotDemo2.class$("org.jfree.data.time.Day")) : class$org$jfree$data$time$Day);
        timeSeries.add((RegularTimePeriod)new Day(1, 3, 2002), 12353.3);
        timeSeries.add((RegularTimePeriod)new Day(2, 3, 2002), 13734.4);
        timeSeries.add((RegularTimePeriod)new Day(3, 3, 2002), 14525.3);
        timeSeries.add((RegularTimePeriod)new Day(4, 3, 2002), 13984.3);
        timeSeries.add((RegularTimePeriod)new Day(5, 3, 2002), 12999.4);
        timeSeries.add((RegularTimePeriod)new Day(6, 3, 2002), 14274.3);
        timeSeries.add((RegularTimePeriod)new Day(7, 3, 2002), 15943.5);
        timeSeries.add((RegularTimePeriod)new Day(8, 3, 2002), 14845.3);
        timeSeries.add((RegularTimePeriod)new Day(9, 3, 2002), 14645.4);
        timeSeries.add((RegularTimePeriod)new Day(10, 3, 2002), 16234.6);
        timeSeries.add((RegularTimePeriod)new Day(11, 3, 2002), 17232.3);
        timeSeries.add((RegularTimePeriod)new Day(12, 3, 2002), 14232.2);
        timeSeries.add((RegularTimePeriod)new Day(13, 3, 2002), 13102.2);
        timeSeries.add((RegularTimePeriod)new Day(14, 3, 2002), 14230.2);
        timeSeries.add((RegularTimePeriod)new Day(15, 3, 2002), 11235.2);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        return timeSeriesCollection;
    }

    private XYDataset createDataset2A() {
        TimeSeries timeSeries = new TimeSeries("Series 2", class$org$jfree$data$time$Day == null ? (class$org$jfree$data$time$Day = OverlaidXYPlotDemo2.class$("org.jfree.data.time.Day")) : class$org$jfree$data$time$Day);
        timeSeries.add((RegularTimePeriod)new Day(3, 3, 2002), 16853.2);
        timeSeries.add((RegularTimePeriod)new Day(4, 3, 2002), 19642.3);
        timeSeries.add((RegularTimePeriod)new Day(5, 3, 2002), 18253.5);
        timeSeries.add((RegularTimePeriod)new Day(6, 3, 2002), 15352.3);
        timeSeries.add((RegularTimePeriod)new Day(7, 3, 2002), 13532.0);
        timeSeries.add((RegularTimePeriod)new Day(8, 3, 2002), 12635.3);
        timeSeries.add((RegularTimePeriod)new Day(9, 3, 2002), 13998.2);
        timeSeries.add((RegularTimePeriod)new Day(10, 3, 2002), 11943.2);
        timeSeries.add((RegularTimePeriod)new Day(11, 3, 2002), 16943.9);
        timeSeries.add((RegularTimePeriod)new Day(12, 3, 2002), 17843.2);
        timeSeries.add((RegularTimePeriod)new Day(13, 3, 2002), 16495.3);
        timeSeries.add((RegularTimePeriod)new Day(14, 3, 2002), 17943.6);
        timeSeries.add((RegularTimePeriod)new Day(15, 3, 2002), 18500.7);
        timeSeries.add((RegularTimePeriod)new Day(16, 3, 2002), 19595.9);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        timeSeriesCollection.setXPosition(TimePeriodAnchor.MIDDLE);
        return timeSeriesCollection;
    }

    private XYDataset createDataset2B() {
        TimeSeries timeSeries = new TimeSeries("Series 2B", class$org$jfree$data$time$Day == null ? (class$org$jfree$data$time$Day = OverlaidXYPlotDemo2.class$("org.jfree.data.time.Day")) : class$org$jfree$data$time$Day);
        timeSeries.add((RegularTimePeriod)new Day(3, 3, 2002), 43.9);
        timeSeries.add((RegularTimePeriod)new Day(4, 3, 2002), 72.6);
        timeSeries.add((RegularTimePeriod)new Day(5, 3, 2002), 89.4);
        timeSeries.add((RegularTimePeriod)new Day(6, 3, 2002), 23.8);
        timeSeries.add((RegularTimePeriod)new Day(7, 3, 2002), 45.0);
        timeSeries.add((RegularTimePeriod)new Day(8, 3, 2002), 65.8);
        timeSeries.add((RegularTimePeriod)new Day(9, 3, 2002), 92.1);
        timeSeries.add((RegularTimePeriod)new Day(10, 3, 2002), 84.7);
        timeSeries.add((RegularTimePeriod)new Day(11, 3, 2002), 77.2);
        timeSeries.add((RegularTimePeriod)new Day(12, 3, 2002), 65.1);
        timeSeries.add((RegularTimePeriod)new Day(13, 3, 2002), 78.5);
        timeSeries.add((RegularTimePeriod)new Day(14, 3, 2002), 75.3);
        timeSeries.add((RegularTimePeriod)new Day(15, 3, 2002), 69.9);
        timeSeries.add((RegularTimePeriod)new Day(20, 3, 2002), 56.6);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        timeSeriesCollection.setXPosition(TimePeriodAnchor.MIDDLE);
        return timeSeriesCollection;
    }

    public static void main(String[] stringArray) {
        OverlaidXYPlotDemo2 overlaidXYPlotDemo2 = new OverlaidXYPlotDemo2("Overlaid XYPlot Demo");
        overlaidXYPlotDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)overlaidXYPlotDemo2));
        overlaidXYPlotDemo2.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

