/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Pie3DPlot;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.Rotation;

public class PieChart3DDemo1
extends ApplicationFrame {
    public PieChart3DDemo1(String string) {
        super(string);
        PieDataset pieDataset = this.createSampleDataset();
        JFreeChart jFreeChart = this.createChart(pieDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private PieDataset createSampleDataset() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"Java"), new Double(43.2));
        defaultPieDataset.setValue((Comparable)((Object)"Visual Basic"), new Double(10.0));
        defaultPieDataset.setValue((Comparable)((Object)"C/C++"), new Double(17.5));
        defaultPieDataset.setValue((Comparable)((Object)"PHP"), new Double(32.5));
        defaultPieDataset.setValue((Comparable)((Object)"Perl"), new Double(0.0));
        return defaultPieDataset;
    }

    private JFreeChart createChart(PieDataset pieDataset) {
        JFreeChart jFreeChart = ChartFactory.createPieChart3D("Pie Chart 3D Demo 1", pieDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.yellow);
        Pie3DPlot pie3DPlot = (Pie3DPlot)jFreeChart.getPlot();
        pie3DPlot.setStartAngle(270.0);
        pie3DPlot.setDirection(Rotation.CLOCKWISE);
        pie3DPlot.setForegroundAlpha(0.5f);
        pie3DPlot.setNoDataMessage("No data to display");
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        PieChart3DDemo1 pieChart3DDemo1 = new PieChart3DDemo1("Pie Chart 3D Demo 1");
        pieChart3DDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)pieChart3DDemo1));
        pieChart3DDemo1.setVisible(true);
    }
}

