/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StackedAreaChartDemo
extends ApplicationFrame {
    public StackedAreaChartDemo(String string) {
        super(string);
        double[][] dArrayArray = new double[][]{{1.0, 4.0, 3.0, 5.0, 5.0, 7.0, 7.0, 8.0}, {5.0, 7.0, 6.0, 8.0, 4.0, 4.0, 2.0, 1.0}, {4.0, 3.0, 2.0, 3.0, 6.0, 3.0, 4.0, 3.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("Series ", "Type ", (double[][])dArrayArray);
        JFreeChart jFreeChart = ChartFactory.createStackedAreaChart("Stacked Area Chart", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.yellow);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setForegroundAlpha(0.5f);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setLowerMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setItemLabelsVisible(Boolean.TRUE);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        StackedAreaChartDemo stackedAreaChartDemo = new StackedAreaChartDemo("Stacked Area Chart Demo");
        stackedAreaChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)stackedAreaChartDemo));
        stackedAreaChartDemo.setVisible(true);
    }
}

