/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.StackedBarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StackedBarChartDemo2
extends ApplicationFrame {
    public StackedBarChartDemo2(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        return DemoDatasetFactory.createCategoryDataset();
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart("Stacked Bar Chart Demo 2", "Category", "Value", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        StackedBarRenderer stackedBarRenderer = (StackedBarRenderer)categoryPlot.getRenderer();
        stackedBarRenderer.setItemLabelsVisible(true);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        StackedBarChartDemo2 stackedBarChartDemo2 = new StackedBarChartDemo2("Stacked Bar Chart Demo 2");
        stackedBarChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)stackedBarChartDemo2));
        stackedBarChartDemo2.setVisible(true);
    }
}

