/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.demo.SampleYSymbolicDataset;
import org.jfree.chart.labels.SymbolicXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.YisSymbolic;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class SymbolicChartDemo1
extends ApplicationFrame {
    public SymbolicChartDemo1(String string) {
        super(string);
        XYDataset xYDataset = this.createDataset();
        NumberAxis numberAxis = new NumberAxis("X");
        SymbolicAxis symbolicAxis = new SymbolicAxis("Y", ((YisSymbolic)((Object)xYDataset)).getYSymbolicValues());
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, symbolicAxis, null);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1, new SymbolicXYToolTipGenerator());
        xYPlot.setRenderer(standardXYItemRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, xYPlot);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public XYDataset createDataset() {
        String[] stringArray = new String[]{"Giraffe", "Gazelle", "Zebra", "Gnu"};
        SampleYSymbolicDataset sampleYSymbolicDataset = new SampleYSymbolicDataset("BY Sample", 40, stringArray, 4, 20, new String[]{"B Fall", "B Spring", "B Summer", "B Winter"});
        return sampleYSymbolicDataset;
    }

    public static void main(String[] stringArray) {
        SymbolicChartDemo1 symbolicChartDemo1 = new SymbolicChartDemo1("Symbolic Chart Demo 1");
        symbolicChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)symbolicChartDemo1));
        symbolicChartDemo1.setVisible(true);
    }
}

