/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Window;
import java.lang.reflect.Array;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.demo.SampleXYSymbolicDataset;
import org.jfree.chart.demo.SampleYSymbolicDataset;
import org.jfree.chart.labels.SymbolicXYToolTipGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.CombinedDataset;
import org.jfree.data.SeriesDataset;
import org.jfree.data.SubSeriesDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.XisSymbolic;
import org.jfree.data.YisSymbolic;
import org.jfree.ui.RefineryUtilities;

public class SymbolicXYPlotDemo {
    public static JFreeChart createXYSymbolicPlot(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        SymbolicAxis symbolicAxis = new SymbolicAxis(string2, ((XisSymbolic)((Object)xYDataset)).getXSymbolicValues());
        SymbolicAxis symbolicAxis2 = new SymbolicAxis(string3, ((YisSymbolic)((Object)xYDataset)).getYSymbolicValues());
        XYPlot xYPlot = new XYPlot(xYDataset, symbolicAxis, symbolicAxis2, null);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1, new SymbolicXYToolTipGenerator());
        xYPlot.setRenderer(standardXYItemRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static SampleYSymbolicDataset createYSymbolicSample1() {
        String[] stringArray = new String[]{"Lion", "Elephant", "Monkey", "Hippopotamus", "Giraffe"};
        SampleYSymbolicDataset sampleYSymbolicDataset = new SampleYSymbolicDataset("AY Sample", 20, stringArray, 4, 20, new String[]{"Fall", "Spring", "Summer", "Winter"});
        return sampleYSymbolicDataset;
    }

    public static SampleYSymbolicDataset createYSymbolicSample2() {
        String[] stringArray = new String[]{"Giraffe", "Gazelle", "Zebra", "Gnu"};
        SampleYSymbolicDataset sampleYSymbolicDataset = new SampleYSymbolicDataset("BY Sample", 40, stringArray, 4, 10, new String[]{"Fall", "Spring", "Summer", "Winter"});
        return sampleYSymbolicDataset;
    }

    public static SampleXYSymbolicDataset createXYSymbolicSample1() {
        String[] stringArray = new String[]{"Atmosphere", "Continental Ecosystem", "Limnic Ecosystem", "Marine Ecosystem"};
        String[] stringArray2 = new String[]{"Ionizing radiations", "Thermic pollutants", "Hydrocarbon", "Synthetic materials", "Pesticides", "Detergent", "Synthetic organic materials", "Sulphur", "Nitrate", "Phosphate", "Heavy metals", "Fluors", "Aerosols", "Dead organic materials", "Pathogen micro-organisms"};
        int[][] nArrayArray = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}};
        int[][] nArrayArray2 = new int[][]{{0, 2, 3, 7, 10, 11, 12, 14, 0, 2, 3, 4, 7, 8, 9, 10, 11, 12, 14, 0, 1, 2, 3, 4, 5, 7, 8, 9, 10, 13, 14, 0, 1, 2, 3, 4, 5, 8, 9, 10, 13, 14}};
        Integer[][] integerArray = (Integer[][])SymbolicXYPlotDemo.toArray(nArrayArray);
        Integer[][] integerArray2 = (Integer[][])SymbolicXYPlotDemo.toArray(nArrayArray2);
        SampleXYSymbolicDataset sampleXYSymbolicDataset = new SampleXYSymbolicDataset("AXY Sample", integerArray, integerArray2, stringArray, stringArray2, new String[]{"A"});
        return sampleXYSymbolicDataset;
    }

    public static SampleXYSymbolicDataset createXYSymbolicSample2() {
        String[] stringArray = new String[]{"Physic pollutant", "Chemical pollutant", "Biological pollutant"};
        String[] stringArray2 = new String[]{"Ionizing radiations", "Thermic pollutants", "Hydrocarbon", "Synthetic materials", "Pesticides", "Detergent", "Synthetic organic materials", "Sulphur", "Nitrate", "Phosphate", "Heavy metals", "Fluors", "Aerosols", "Dead organic materials", "Pathogen micro-organisms"};
        int[][] nArrayArray = new int[][]{{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2}};
        int[][] nArrayArray2 = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}};
        Integer[][] integerArray = (Integer[][])SymbolicXYPlotDemo.toArray(nArrayArray);
        Integer[][] integerArray2 = (Integer[][])SymbolicXYPlotDemo.toArray(nArrayArray2);
        SampleXYSymbolicDataset sampleXYSymbolicDataset = new SampleXYSymbolicDataset("BXY Sample", integerArray, integerArray2, stringArray, stringArray2, new String[]{"B"});
        return sampleXYSymbolicDataset;
    }

    private static void displayXYSymbolic(String string, XYDataset xYDataset, String string2, String string3, String string4) {
        JFreeChart jFreeChart = SymbolicXYPlotDemo.createXYSymbolicPlot(string2, string3, string4, xYDataset, true);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        ChartFrame chartFrame = new ChartFrame(string, jFreeChart);
        chartFrame.pack();
        RefineryUtilities.positionFrameRandomly((Window)chartFrame);
        chartFrame.show();
    }

    private static void displayXYSymbolicOverlaid(String string, XYDataset xYDataset, XYDataset xYDataset2) {
        String string2 = "Pollutant Overlaid";
        String string3 = "Contamination and Type";
        String string4 = "Pollutant";
        String[] stringArray = SampleXYSymbolicDataset.combineXSymbolicDataset((XisSymbolic)((Object)xYDataset), (XisSymbolic)((Object)xYDataset2));
        String[] stringArray2 = SampleXYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)((Object)xYDataset), (YisSymbolic)((Object)xYDataset2));
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add(xYDataset);
        combinedDataset.add(xYDataset2);
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
        SymbolicAxis symbolicAxis = new SymbolicAxis(string3, stringArray);
        SymbolicAxis symbolicAxis2 = new SymbolicAxis(string4, stringArray2);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1, null);
        XYPlot xYPlot = new XYPlot(subSeriesDataset, symbolicAxis, symbolicAxis2, standardXYItemRenderer);
        StandardXYItemRenderer standardXYItemRenderer2 = new StandardXYItemRenderer(1, null);
        xYPlot.setSecondaryDataset(0, subSeriesDataset2);
        xYPlot.setSecondaryRenderer(0, standardXYItemRenderer2);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, true);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame chartFrame = new ChartFrame(string, jFreeChart);
        chartFrame.pack();
        RefineryUtilities.positionFrameRandomly((Window)chartFrame);
        chartFrame.show();
    }

    private static void displayXYSymbolicCombinedHorizontally(String string, XYDataset xYDataset, XYDataset xYDataset2) {
        String string2 = "Pollutant Horizontally Combined";
        String string3 = "Contamination";
        String string4 = "Type";
        String string5 = "Pollutant";
        String[] stringArray = SampleXYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)((Object)xYDataset), (YisSymbolic)((Object)xYDataset2));
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add(xYDataset);
        combinedDataset.add(xYDataset2);
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
        JFreeChart jFreeChart = null;
        SymbolicAxis symbolicAxis = new SymbolicAxis(string3, ((XisSymbolic)((Object)xYDataset)).getXSymbolicValues());
        SymbolicAxis symbolicAxis2 = new SymbolicAxis(string4, ((XisSymbolic)((Object)xYDataset2)).getXSymbolicValues());
        SymbolicAxis symbolicAxis3 = new SymbolicAxis(string5, stringArray);
        CombinedRangeXYPlot combinedRangeXYPlot = new CombinedRangeXYPlot(symbolicAxis3);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1, null);
        XYPlot xYPlot = new XYPlot(subSeriesDataset, symbolicAxis, null, standardXYItemRenderer);
        XYPlot xYPlot2 = new XYPlot(subSeriesDataset2, symbolicAxis2, null, standardXYItemRenderer);
        combinedRangeXYPlot.add(xYPlot, 1);
        combinedRangeXYPlot.add(xYPlot2, 1);
        jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, combinedRangeXYPlot, true);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame chartFrame = new ChartFrame(string, jFreeChart);
        chartFrame.pack();
        RefineryUtilities.positionFrameRandomly((Window)chartFrame);
        chartFrame.show();
    }

    private static void displayXYSymbolicCombinedVertically(String string, XYDataset xYDataset, XYDataset xYDataset2) {
        String string2 = "Pollutant Vertically Combined";
        String string3 = "Contamination and Type";
        String string4 = "Pollutant";
        String[] stringArray = SampleXYSymbolicDataset.combineXSymbolicDataset((XisSymbolic)((Object)xYDataset), (XisSymbolic)((Object)xYDataset2));
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add(xYDataset);
        combinedDataset.add(xYDataset2);
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
        SymbolicAxis symbolicAxis = new SymbolicAxis(string3, stringArray);
        SymbolicAxis symbolicAxis2 = new SymbolicAxis(string4, ((YisSymbolic)((Object)xYDataset)).getYSymbolicValues());
        SymbolicAxis symbolicAxis3 = new SymbolicAxis(string4, ((YisSymbolic)((Object)xYDataset2)).getYSymbolicValues());
        CombinedDomainXYPlot combinedDomainXYPlot = new CombinedDomainXYPlot(symbolicAxis);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1, null);
        XYPlot xYPlot = new XYPlot(subSeriesDataset, null, symbolicAxis2, standardXYItemRenderer);
        XYPlot xYPlot2 = new XYPlot(subSeriesDataset2, null, symbolicAxis3, standardXYItemRenderer);
        combinedDomainXYPlot.add(xYPlot, 1);
        combinedDomainXYPlot.add(xYPlot2, 1);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, combinedDomainXYPlot, true);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        ChartFrame chartFrame = new ChartFrame(string, jFreeChart);
        chartFrame.pack();
        RefineryUtilities.positionFrameRandomly((Window)chartFrame);
        chartFrame.show();
    }

    private static Object toArray(Object object) {
        if (object == null) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object;
        }
        Class<?> clazz2 = clazz.getComponentType();
        int n = 1;
        while (!clazz2.isPrimitive()) {
            if (!clazz2.isArray()) {
                return object;
            }
            ++n;
            clazz2 = clazz2.getComponentType();
        }
        int[] nArray = new int[n];
        nArray[0] = Array.getLength(object);
        Object[] objectArray = null;
        try {
            if (clazz2.equals(Integer.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Integer"), nArray);
            } else if (clazz2.equals(Double.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Double"), nArray);
            } else if (clazz2.equals(Long.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Long"), nArray);
            } else if (clazz2.equals(Float.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Float"), nArray);
            } else if (clazz2.equals(Short.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Short"), nArray);
            } else if (clazz2.equals(Byte.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Byte"), nArray);
            } else if (clazz2.equals(Character.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Character"), nArray);
            } else if (clazz2.equals(Boolean.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Boolean"), nArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException);
        }
        for (int i = 0; i < nArray[0]; ++i) {
            objectArray[i] = n != 1 ? SymbolicXYPlotDemo.toArray(Array.get(object, i)) : Array.get(object, i);
        }
        return objectArray;
    }

    public static void main(String[] stringArray) {
        SampleXYSymbolicDataset sampleXYSymbolicDataset = SymbolicXYPlotDemo.createXYSymbolicSample1();
        SampleXYSymbolicDataset sampleXYSymbolicDataset2 = SymbolicXYPlotDemo.createXYSymbolicSample2();
        SymbolicXYPlotDemo.displayXYSymbolic("Example 1", sampleXYSymbolicDataset, "Pollutant", "contamination", "pollutant");
        SymbolicXYPlotDemo.displayXYSymbolic("Example 2", sampleXYSymbolicDataset2, "Pollutant", "type", "pollutant");
        SymbolicXYPlotDemo.displayXYSymbolicCombinedHorizontally("Example 3", (SampleXYSymbolicDataset)sampleXYSymbolicDataset.clone(), (SampleXYSymbolicDataset)sampleXYSymbolicDataset2.clone());
        SymbolicXYPlotDemo.displayXYSymbolicCombinedVertically("Example 4", (SampleXYSymbolicDataset)sampleXYSymbolicDataset.clone(), (SampleXYSymbolicDataset)sampleXYSymbolicDataset2.clone());
        SymbolicXYPlotDemo.displayXYSymbolicOverlaid("Example 5", (SampleXYSymbolicDataset)sampleXYSymbolicDataset.clone(), (SampleXYSymbolicDataset)sampleXYSymbolicDataset2.clone());
    }
}

