/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.text.SimpleDateFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Spacer;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo12
extends ApplicationFrame {
    static /* synthetic */ Class class$org$jfree$data$time$Minute;

    public TimeSeriesDemo12(String string) {
        super(string);
        XYDataset xYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        Cloneable cloneable;
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Sample Chart", "Date", "Value", xYDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        StandardLegend standardLegend = (StandardLegend)jFreeChart.getLegend();
        standardLegend.setDisplaySeriesShapes(true);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairVisible(false);
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer instanceof StandardXYItemRenderer) {
            cloneable = (StandardXYItemRenderer)xYItemRenderer;
            ((StandardXYItemRenderer)cloneable).setPlotShapes(true);
            ((StandardXYItemRenderer)cloneable).setShapesFilled(true);
            xYItemRenderer.setSeriesStroke(0, new BasicStroke(2.0f));
            xYItemRenderer.setSeriesStroke(1, new BasicStroke(2.0f));
        }
        cloneable = (DateAxis)xYPlot.getDomainAxis();
        ((DateAxis)cloneable).setDateFormatOverride(new SimpleDateFormat("hh:mma"));
        return jFreeChart;
    }

    private XYDataset createDataset() {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.setDomainIsPointsInTime(true);
        TimeSeries timeSeries = new TimeSeries("Series 1", class$org$jfree$data$time$Minute == null ? (class$org$jfree$data$time$Minute = TimeSeriesDemo12.class$("org.jfree.data.time.Minute")) : class$org$jfree$data$time$Minute);
        timeSeries.add((RegularTimePeriod)new Minute(0, 0, 7, 12, 2003), 1.2);
        timeSeries.add((RegularTimePeriod)new Minute(30, 12, 7, 12, 2003), 3.0);
        timeSeries.add((RegularTimePeriod)new Minute(15, 14, 7, 12, 2003), 8.0);
        TimeSeries timeSeries2 = new TimeSeries("Series 2", class$org$jfree$data$time$Minute == null ? (class$org$jfree$data$time$Minute = TimeSeriesDemo12.class$("org.jfree.data.time.Minute")) : class$org$jfree$data$time$Minute);
        timeSeries2.add((RegularTimePeriod)new Minute(0, 3, 7, 12, 2003), 0.0);
        timeSeries2.add((RegularTimePeriod)new Minute(30, 9, 7, 12, 2003), 0.0);
        timeSeries2.add((RegularTimePeriod)new Minute(15, 10, 7, 12, 2003), 0.0);
        timeSeriesCollection.addSeries(timeSeries);
        timeSeriesCollection.addSeries(timeSeries2);
        return timeSeriesCollection;
    }

    public static void main(String[] stringArray) {
        TimeSeriesDemo12 timeSeriesDemo12 = new TimeSeriesDemo12("Time Series Demo 12");
        timeSeriesDemo12.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)timeSeriesDemo12));
        timeSeriesDemo12.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

