/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.text.DecimalFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Spacer;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class WaterfallChartDemo
extends ApplicationFrame {
    public WaterfallChartDemo(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setEnforceFileExtensions(false);
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(15.76, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Labour"));
        defaultCategoryDataset.addValue(8.66, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Administration"));
        defaultCategoryDataset.addValue(4.71, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Marketing"));
        defaultCategoryDataset.addValue(3.51, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Distribution"));
        defaultCategoryDataset.addValue(32.64, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Total Expense"));
        return defaultCategoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createWaterfallChart("Product Cost Breakdown", "Expense Category", "Cost Per Unit", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setRangeGridlinePaint(Color.white);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        DecimalFormat decimalFormat = new DecimalFormat("##,###");
        decimalFormat.setNegativePrefix("(");
        decimalFormat.setNegativeSuffix(")");
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(5.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(10.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(20.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(50.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(100.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(200.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(500.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(1000.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(2000.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(5000.0, decimalFormat));
        valueAxis.setStandardTickUnits(tickUnits);
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setDrawBarOutline(false);
        DecimalFormat decimalFormat2 = new DecimalFormat("$##,###.00");
        decimalFormat2.setNegativePrefix("(");
        decimalFormat2.setNegativeSuffix(")");
        barRenderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator(decimalFormat2, false));
        barRenderer.setItemLabelsVisible(true);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        WaterfallChartDemo waterfallChartDemo = new WaterfallChartDemo("Waterfall Chart Demo");
        waterfallChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)waterfallChartDemo));
        waterfallChartDemo.setVisible(true);
    }
}

