/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.demo.DemoDatasetFactory;
import org.jfree.chart.labels.TimeSeriesToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYBarChartDemo
extends ApplicationFrame {
    public XYBarChartDemo(String string) {
        super(string);
        TimeSeriesCollection timeSeriesCollection = DemoDatasetFactory.createTimeSeriesCollection1();
        timeSeriesCollection.setDomainIsPointsInTime(false);
        JFreeChart jFreeChart = ChartFactory.createXYBarChart(string, "X", "Y", timeSeriesCollection, PlotOrientation.VERTICAL, true, false, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        XYItemRenderer xYItemRenderer = jFreeChart.getXYPlot().getRenderer();
        xYItemRenderer.setToolTipGenerator(new TimeSeriesToolTipGenerator());
        XYPlot xYPlot = jFreeChart.getXYPlot();
        DateAxis dateAxis = (DateAxis)xYPlot.getDomainAxis();
        dateAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 300));
        this.setContentPane(chartPanel);
    }

    public static void main(String[] stringArray) {
        XYBarChartDemo xYBarChartDemo = new XYBarChartDemo("XY Bar Chart Demo");
        xYBarChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)xYBarChartDemo));
        xYBarChartDemo.setVisible(true);
    }
}

