/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.BoxAndWhiskerCalculator;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerXYDataset;
import org.jfree.date.DateUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYBoxAndWhiskerDemo
extends ApplicationFrame {
    public XYBoxAndWhiskerDemo(String string) {
        super(string);
        BoxAndWhiskerXYDataset boxAndWhiskerXYDataset = XYBoxAndWhiskerDemo.createSampleDataset();
        JFreeChart jFreeChart = this.createChart(boxAndWhiskerXYDataset);
        jFreeChart.getXYPlot().setOrientation(PlotOrientation.VERTICAL);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(600, 400));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(BoxAndWhiskerXYDataset boxAndWhiskerXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createBoxAndWhiskerChart("Box-and-Whisker Demo", "Time", "Value", boxAndWhiskerXYDataset, true);
        return jFreeChart;
    }

    public static BoxAndWhiskerXYDataset createSampleDataset() {
        DefaultBoxAndWhiskerXYDataset defaultBoxAndWhiskerXYDataset = new DefaultBoxAndWhiskerXYDataset("Test");
        for (int i = 0; i < 14; ++i) {
            Date date = DateUtilities.createDate((int)2003, (int)7, (int)(i + 1), (int)12, (int)0);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int j = 0; j < 10; ++j) {
                arrayList.add(new Double(10.0 + Math.random() * 10.0));
                arrayList.add(new Double(13.0 + Math.random() * 4.0));
            }
            defaultBoxAndWhiskerXYDataset.add(date, BoxAndWhiskerCalculator.calculateBoxAndWhiskerStatistics(arrayList));
        }
        return defaultBoxAndWhiskerXYDataset;
    }

    public static void main(String[] stringArray) {
        XYBoxAndWhiskerDemo xYBoxAndWhiskerDemo = new XYBoxAndWhiskerDemo("Box-and-Whisker Demo");
        xYBoxAndWhiskerDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)xYBoxAndWhiskerDemo));
        xYBoxAndWhiskerDemo.setVisible(true);
    }
}

